/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharSequenceUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings$1;
import org.apache.commons.lang3.Strings$Builder;
import org.apache.commons.lang3.Strings$CiStrings;
import org.apache.commons.lang3.Strings$CsStrings;
import org.apache.commons.lang3.function.ToBooleanBiFunction;

public abstract class Strings {
    public static final Strings CI = new Strings$CiStrings(true, null);
    public static final Strings CS = new Strings$CsStrings(true, null);
    private final boolean ignoreCase;
    private final boolean nullIsLess;

    public static final Strings$Builder builder() {
        return new Strings$Builder(null);
    }

    private static boolean containsAny(ToBooleanBiFunction<CharSequence, CharSequence> toBooleanBiFunction, CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StringUtils.isEmpty(charSequence) || ArrayUtils.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!toBooleanBiFunction.applyAsBoolean(charSequence, charSequence2)) continue;
            return true;
        }
        return false;
    }

    private static boolean eq(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private Strings(boolean bl2, boolean bl3) {
        this.ignoreCase = bl2;
        this.nullIsLess = bl3;
    }

    public String appendIfMissing(String string, CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (string == null || StringUtils.isEmpty(charSequence) || this.endsWith(string, charSequence)) {
            return string;
        }
        if (ArrayUtils.isNotEmpty(charSequenceArray)) {
            for (CharSequence charSequence2 : charSequenceArray) {
                if (!this.endsWith(string, charSequence2)) continue;
                return string;
            }
        }
        return string + charSequence;
    }

    public abstract int compare(String var1, String var2);

    public abstract boolean contains(CharSequence var1, CharSequence var2);

    public boolean containsAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return Strings.containsAny(this::contains, charSequence, charSequenceArray);
    }

    public boolean endsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        int n2 = charSequence2.length();
        if (n2 > charSequence.length()) {
            return false;
        }
        return CharSequenceUtils.regionMatches(charSequence, this.ignoreCase, charSequence.length() - n2, charSequence2, 0, n2);
    }

    public boolean endsWithAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StringUtils.isEmpty(charSequence) || ArrayUtils.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!this.endsWith(charSequence, charSequence2)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean equals(CharSequence var1, CharSequence var2);

    public abstract boolean equals(String var1, String var2);

    public boolean equalsAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (ArrayUtils.isNotEmpty(charSequenceArray)) {
            for (CharSequence charSequence2 : charSequenceArray) {
                if (!this.equals(charSequence, charSequence2)) continue;
                return true;
            }
        }
        return false;
    }

    public int indexOf(CharSequence charSequence, CharSequence charSequence2) {
        return this.indexOf(charSequence, charSequence2, 0);
    }

    public abstract int indexOf(CharSequence var1, CharSequence var2, int var3);

    public boolean isCaseSensitive() {
        return !this.ignoreCase;
    }

    boolean isNullIsLess() {
        return this.nullIsLess;
    }

    public int lastIndexOf(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null) {
            return -1;
        }
        return this.lastIndexOf(charSequence, charSequence2, charSequence.length());
    }

    public abstract int lastIndexOf(CharSequence var1, CharSequence var2, int var3);

    public String prependIfMissing(String string, CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (string == null || StringUtils.isEmpty(charSequence) || this.startsWith(string, charSequence)) {
            return string;
        }
        if (ArrayUtils.isNotEmpty(charSequenceArray)) {
            for (CharSequence charSequence2 : charSequenceArray) {
                if (!this.startsWith(string, charSequence2)) continue;
                return string;
            }
        }
        return charSequence + string;
    }

    public String remove(String string, String string2) {
        return this.replace(string, string2, "", -1);
    }

    public String removeEnd(String string, CharSequence charSequence) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(charSequence)) {
            return string;
        }
        if (this.endsWith(string, charSequence)) {
            return string.substring(0, string.length() - charSequence.length());
        }
        return string;
    }

    public String removeStart(String string, CharSequence charSequence) {
        if (string != null && this.startsWith(string, charSequence)) {
            return string.substring(StringUtils.length(charSequence));
        }
        return string;
    }

    public String replace(String string, String string2, String string3) {
        return this.replace(string, string2, string3, -1);
    }

    public String replace(String string, String string2, String string3, int n2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2) || string3 == null || n2 == 0) {
            return string;
        }
        if (this.ignoreCase) {
            string2 = string2.toLowerCase();
        }
        int n3 = 0;
        int n4 = this.indexOf(string, string2, 0);
        if (n4 == -1) {
            return string;
        }
        int n5 = string2.length();
        int n6 = Math.max(string3.length() - n5, 0);
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n6 *= n2 < 0 ? 16 : Math.min(n2, 64)));
        while (n4 != -1) {
            stringBuilder.append(string, n3, n4).append(string3);
            n3 = n4 + n5;
            if (--n2 == 0) break;
            n4 = this.indexOf(string, string2, n3);
        }
        stringBuilder.append(string, n3, string.length());
        return stringBuilder.toString();
    }

    public String replaceOnce(String string, String string2, String string3) {
        return this.replace(string, string2, string3, 1);
    }

    public boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        int n2 = charSequence2.length();
        if (n2 > charSequence.length()) {
            return false;
        }
        return CharSequenceUtils.regionMatches(charSequence, this.ignoreCase, 0, charSequence2, 0, n2);
    }

    public boolean startsWithAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StringUtils.isEmpty(charSequence) || ArrayUtils.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!this.startsWith(charSequence, charSequence2)) continue;
            return true;
        }
        return false;
    }

    /* synthetic */ Strings(boolean bl2, boolean bl3, Strings$1 strings$1) {
        this(bl2, bl3);
    }

    static /* synthetic */ boolean access$300(Object object, Object object2) {
        return Strings.eq(object, object2);
    }
}

