/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.arch;

import org.apache.commons.lang3.arch.Processor$Arch;
import org.apache.commons.lang3.arch.Processor$Type;

public class Processor {
    private final Processor$Arch arch;
    private final Processor$Type type;

    public Processor(Processor$Arch processor$Arch, Processor$Type processor$Type) {
        this.arch = processor$Arch;
        this.type = processor$Type;
    }

    public Processor$Arch getArch() {
        return this.arch;
    }

    public Processor$Type getType() {
        return this.type;
    }

    public boolean is32Bit() {
        return Processor$Arch.BIT_32 == this.arch;
    }

    public boolean is64Bit() {
        return Processor$Arch.BIT_64 == this.arch;
    }

    public boolean isAarch64() {
        return Processor$Type.AARCH_64 == this.type;
    }

    public boolean isIA64() {
        return Processor$Type.IA_64 == this.type;
    }

    public boolean isPPC() {
        return Processor$Type.PPC == this.type;
    }

    public boolean isRISCV() {
        return Processor$Type.RISC_V == this.type;
    }

    public boolean isX86() {
        return Processor$Type.X86 == this.type;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.type.getLabel()).append(' ').append(this.arch.getLabel());
        return stringBuilder.toString();
    }
}

