/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DiffResult<T>
implements Iterable<Diff<?>> {
    public static final String OBJECTS_SAME_STRING = "";
    private final List<Diff<?>> diffList;
    private final T lhs;
    private final T rhs;
    private final ToStringStyle style;
    private final String toStringFormat;

    DiffResult(T t2, T t3, List<Diff<?>> list, ToStringStyle toStringStyle, String string) {
        this.diffList = Objects.requireNonNull(list, "diffList");
        this.lhs = Objects.requireNonNull(t2, "lhs");
        this.rhs = Objects.requireNonNull(t3, "rhs");
        this.style = Objects.requireNonNull(toStringStyle, "style");
        this.toStringFormat = Objects.requireNonNull(string, "toStringFormat");
    }

    public List<Diff<?>> getDiffs() {
        return Collections.unmodifiableList(this.diffList);
    }

    public T getLeft() {
        return this.lhs;
    }

    public int getNumberOfDiffs() {
        return this.diffList.size();
    }

    public T getRight() {
        return this.rhs;
    }

    public ToStringStyle getToStringStyle() {
        return this.style;
    }

    @Override
    public Iterator<Diff<?>> iterator() {
        return this.diffList.iterator();
    }

    public String toString() {
        DiffResult diffResult = this;
        return diffResult.toString(diffResult.style);
    }

    public String toString(ToStringStyle object) {
        if (this.diffList.isEmpty()) {
            return OBJECTS_SAME_STRING;
        }
        ToStringBuilder toStringBuilder = new ToStringBuilder(this.lhs, (ToStringStyle)object);
        object = new ToStringBuilder(this.rhs, (ToStringStyle)object);
        this.diffList.forEach(arg_0 -> DiffResult.lambda$toString$0(toStringBuilder, (ToStringBuilder)object, arg_0));
        return String.format(this.toStringFormat, toStringBuilder.build(), ((ToStringBuilder)object).build());
    }

    private static /* synthetic */ void lambda$toString$0(ToStringBuilder toStringBuilder, ToStringBuilder toStringBuilder2, Diff diff) {
        toStringBuilder.append(diff.getFieldName(), diff.getLeft());
        toStringBuilder2.append(diff.getFieldName(), diff.getRight());
    }
}

