/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.AbstractCircuitBreaker$State;
import org.apache.commons.lang3.concurrent.CircuitBreaker;

public abstract class AbstractCircuitBreaker<T>
implements CircuitBreaker<T> {
    public static final String PROPERTY_NAME = "open";
    protected final AtomicReference<AbstractCircuitBreaker$State> state = new AtomicReference<AbstractCircuitBreaker$State>(AbstractCircuitBreaker$State.CLOSED);
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    protected static boolean isOpen(AbstractCircuitBreaker$State abstractCircuitBreaker$State) {
        return abstractCircuitBreaker$State == AbstractCircuitBreaker$State.OPEN;
    }

    public void addChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    protected void changeState(AbstractCircuitBreaker$State abstractCircuitBreaker$State) {
        if (this.state.compareAndSet(abstractCircuitBreaker$State.oppositeState(), abstractCircuitBreaker$State)) {
            this.changeSupport.firePropertyChange(PROPERTY_NAME, !AbstractCircuitBreaker.isOpen(abstractCircuitBreaker$State), AbstractCircuitBreaker.isOpen(abstractCircuitBreaker$State));
        }
    }

    @Override
    public abstract boolean checkState();

    @Override
    public void close() {
        this.changeState(AbstractCircuitBreaker$State.CLOSED);
    }

    @Override
    public abstract boolean incrementAndCheckState(T var1);

    @Override
    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public boolean isOpen() {
        return AbstractCircuitBreaker.isOpen(this.state.get());
    }

    @Override
    public void open() {
        this.changeState(AbstractCircuitBreaker$State.OPEN);
    }

    public void removeChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

