/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Objects;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;

public abstract class AbstractConcurrentInitializer<T, E extends Exception>
implements ConcurrentInitializer<T> {
    private final FailableConsumer<? super T, ? extends Exception> closer;
    private final FailableSupplier<? extends T, ? extends Exception> initializer;

    public AbstractConcurrentInitializer() {
        this(FailableSupplier.nul(), FailableConsumer.nop());
    }

    AbstractConcurrentInitializer(FailableSupplier<? extends T, ? extends Exception> failableSupplier, FailableConsumer<? super T, ? extends Exception> failableConsumer) {
        this.closer = Objects.requireNonNull(failableConsumer, "closer");
        this.initializer = Objects.requireNonNull(failableSupplier, "initializer");
    }

    public void close() throws ConcurrentException {
        if (this.isInitialized()) {
            try {
                this.closer.accept(this.get());
                return;
            }
            catch (Exception exception) {
                throw new ConcurrentException(ExceptionUtils.throwUnchecked(exception));
            }
        }
    }

    protected abstract E getTypedException(Exception var1);

    protected T initialize() throws E {
        try {
            return this.initializer.get();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ExceptionUtils.throwUnchecked(exception);
            E e2 = this.getTypedException(exception2);
            if (e2.getClass().isAssignableFrom(exception2.getClass())) {
                throw exception2;
            }
            throw e2;
        }
    }

    protected abstract boolean isInitialized();
}

