/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import org.apache.commons.lang3.concurrent.AtomicSafeInitializer$1;
import org.apache.commons.lang3.concurrent.AtomicSafeInitializer$Builder;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;

public class AtomicSafeInitializer<T>
extends AbstractConcurrentInitializer<T, ConcurrentException> {
    private static final Object NO_INIT = new Object();
    private final AtomicReference<AtomicSafeInitializer<T>> factory = new AtomicReference();
    private final AtomicReference<T> reference = new AtomicReference<T>(this.getNoInit());

    public static <T> AtomicSafeInitializer$Builder<AtomicSafeInitializer<T>, T> builder() {
        return new AtomicSafeInitializer$Builder();
    }

    public AtomicSafeInitializer() {
    }

    private AtomicSafeInitializer(FailableSupplier<T, ConcurrentException> failableSupplier, FailableConsumer<T, ConcurrentException> failableConsumer) {
        super(failableSupplier, failableConsumer);
    }

    @Override
    public final T get() throws ConcurrentException {
        T t2;
        while ((t2 = this.reference.get()) == this.getNoInit()) {
            if (!this.factory.compareAndSet(null, this)) continue;
            try {
                this.reference.set(this.initialize());
            }
            catch (Throwable throwable) {
                this.factory.set(null);
                Throwable throwable2 = ExceptionUtils.throwUnchecked(throwable);
                throw throwable2 instanceof ConcurrentException ? (ConcurrentException)throwable2 : new ConcurrentException(throwable2);
            }
        }
        return t2;
    }

    private T getNoInit() {
        return (T)NO_INIT;
    }

    @Override
    protected ConcurrentException getTypedException(Exception exception) {
        return new ConcurrentException(exception);
    }

    @Override
    public boolean isInitialized() {
        return this.reference.get() != NO_INIT;
    }

    /* synthetic */ AtomicSafeInitializer(FailableSupplier failableSupplier, FailableConsumer failableConsumer, AtomicSafeInitializer$1 atomicSafeInitializer$1) {
        this(failableSupplier, failableConsumer);
    }
}

