/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;
import org.apache.commons.lang3.concurrent.ConcurrentUtils$ConstantFuture;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ConcurrentUtils {
    static Throwable checkedException(Throwable throwable) {
        Validate.isTrue(ExceptionUtils.isChecked(throwable), "Not a checked exception: %s", throwable);
        return throwable;
    }

    public static <T> Future<T> constantFuture(T t2) {
        return new ConcurrentUtils$ConstantFuture<T>(t2);
    }

    public static <K, V> V createIfAbsent(ConcurrentMap<K, V> concurrentMap, K k2, ConcurrentInitializer<V> concurrentInitializer) throws ConcurrentException {
        if (concurrentMap == null || concurrentInitializer == null) {
            return null;
        }
        Object v2 = concurrentMap.get(k2);
        if (v2 == null) {
            return ConcurrentUtils.putIfAbsent(concurrentMap, k2, concurrentInitializer.get());
        }
        return v2;
    }

    public static <K, V> V createIfAbsentUnchecked(ConcurrentMap<K, V> concurrentMap, K k2, ConcurrentInitializer<V> concurrentInitializer) {
        try {
            return ConcurrentUtils.createIfAbsent(concurrentMap, k2, concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
    }

    public static ConcurrentException extractCause(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ExceptionUtils.throwUnchecked(executionException.getCause());
        return new ConcurrentException(executionException.getMessage(), executionException.getCause());
    }

    public static ConcurrentRuntimeException extractCauseUnchecked(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ExceptionUtils.throwUnchecked(executionException.getCause());
        return new ConcurrentRuntimeException(executionException.getMessage(), executionException.getCause());
    }

    public static void handleCause(ExecutionException exception) throws ConcurrentException {
        if ((exception = ConcurrentUtils.extractCause(exception)) != null) {
            throw exception;
        }
    }

    public static void handleCauseUnchecked(ExecutionException exception) {
        if ((exception = ConcurrentUtils.extractCauseUnchecked(exception)) != null) {
            throw exception;
        }
    }

    public static <T> T initialize(ConcurrentInitializer<T> concurrentInitializer) throws ConcurrentException {
        if (concurrentInitializer != null) {
            return concurrentInitializer.get();
        }
        return null;
    }

    public static <T> T initializeUnchecked(ConcurrentInitializer<T> concurrentInitializer) {
        try {
            return ConcurrentUtils.initialize(concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> concurrentMap, K k2, V v2) {
        if (concurrentMap == null) {
            return null;
        }
        if ((concurrentMap = concurrentMap.putIfAbsent(k2, v2)) != null) {
            return (V)concurrentMap;
        }
        return v2;
    }

    private ConcurrentUtils() {
    }
}

