/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.AbstractCircuitBreaker;
import org.apache.commons.lang3.concurrent.AbstractCircuitBreaker$State;
import org.apache.commons.lang3.concurrent.EventCountCircuitBreaker$AbstractStateStrategy;
import org.apache.commons.lang3.concurrent.EventCountCircuitBreaker$CheckIntervalData;
import org.apache.commons.lang3.concurrent.EventCountCircuitBreaker$StateStrategyClosed;
import org.apache.commons.lang3.concurrent.EventCountCircuitBreaker$StateStrategyOpen;

public class EventCountCircuitBreaker
extends AbstractCircuitBreaker<Integer> {
    private static final Map<AbstractCircuitBreaker$State, EventCountCircuitBreaker$AbstractStateStrategy> STRATEGY_MAP = EventCountCircuitBreaker.createStrategyMap();
    private final AtomicReference<EventCountCircuitBreaker$CheckIntervalData> checkIntervalData = new AtomicReference<EventCountCircuitBreaker$CheckIntervalData>(new EventCountCircuitBreaker$CheckIntervalData(0, 0L));
    private final int openingThreshold;
    private final long openingInterval;
    private final int closingThreshold;
    private final long closingInterval;

    private static Map<AbstractCircuitBreaker$State, EventCountCircuitBreaker$AbstractStateStrategy> createStrategyMap() {
        EnumMap<AbstractCircuitBreaker$State, EventCountCircuitBreaker$AbstractStateStrategy> enumMap = new EnumMap<AbstractCircuitBreaker$State, EventCountCircuitBreaker$AbstractStateStrategy>(AbstractCircuitBreaker$State.class);
        enumMap.put(AbstractCircuitBreaker$State.CLOSED, new EventCountCircuitBreaker$StateStrategyClosed(null));
        enumMap.put(AbstractCircuitBreaker$State.OPEN, new EventCountCircuitBreaker$StateStrategyOpen(null));
        return enumMap;
    }

    private static EventCountCircuitBreaker$AbstractStateStrategy stateStrategy(AbstractCircuitBreaker$State abstractCircuitBreaker$State) {
        return STRATEGY_MAP.get((Object)abstractCircuitBreaker$State);
    }

    public EventCountCircuitBreaker(int n2, long l2, TimeUnit timeUnit) {
        this(n2, l2, timeUnit, n2);
    }

    public EventCountCircuitBreaker(int n2, long l2, TimeUnit timeUnit, int n3) {
        this(n2, l2, timeUnit, n3, l2, timeUnit);
    }

    public EventCountCircuitBreaker(int n2, long l2, TimeUnit timeUnit, int n3, long l3, TimeUnit timeUnit2) {
        this.openingThreshold = n2;
        this.openingInterval = timeUnit.toNanos(l2);
        this.closingThreshold = n3;
        this.closingInterval = timeUnit2.toNanos(l3);
    }

    private void changeStateAndStartNewCheckInterval(AbstractCircuitBreaker$State abstractCircuitBreaker$State) {
        this.changeState(abstractCircuitBreaker$State);
        this.checkIntervalData.set(new EventCountCircuitBreaker$CheckIntervalData(0, this.nanoTime()));
    }

    @Override
    public boolean checkState() {
        return this.performStateCheck(0);
    }

    @Override
    public void close() {
        super.close();
        this.checkIntervalData.set(new EventCountCircuitBreaker$CheckIntervalData(0, this.nanoTime()));
    }

    public long getClosingInterval() {
        return this.closingInterval;
    }

    public int getClosingThreshold() {
        return this.closingThreshold;
    }

    public long getOpeningInterval() {
        return this.openingInterval;
    }

    public int getOpeningThreshold() {
        return this.openingThreshold;
    }

    public boolean incrementAndCheckState() {
        return this.incrementAndCheckState(1);
    }

    @Override
    public boolean incrementAndCheckState(Integer n2) {
        return this.performStateCheck(n2);
    }

    long nanoTime() {
        return System.nanoTime();
    }

    private EventCountCircuitBreaker$CheckIntervalData nextCheckIntervalData(int n2, EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData, AbstractCircuitBreaker$State abstractCircuitBreaker$State, long l2) {
        EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData2 = EventCountCircuitBreaker.stateStrategy(abstractCircuitBreaker$State).isCheckIntervalFinished(this, eventCountCircuitBreaker$CheckIntervalData, l2) ? new EventCountCircuitBreaker$CheckIntervalData(n2, l2) : eventCountCircuitBreaker$CheckIntervalData.increment(n2);
        return eventCountCircuitBreaker$CheckIntervalData2;
    }

    @Override
    public void open() {
        super.open();
        this.checkIntervalData.set(new EventCountCircuitBreaker$CheckIntervalData(0, this.nanoTime()));
    }

    private boolean performStateCheck(int n2) {
        long l2;
        AbstractCircuitBreaker$State abstractCircuitBreaker$State;
        EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData;
        EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData2;
        do {
            l2 = this.nanoTime();
            abstractCircuitBreaker$State = this.state.get();
        } while (!this.updateCheckIntervalData(eventCountCircuitBreaker$CheckIntervalData2 = this.checkIntervalData.get(), eventCountCircuitBreaker$CheckIntervalData = this.nextCheckIntervalData(n2, eventCountCircuitBreaker$CheckIntervalData2, abstractCircuitBreaker$State, l2)));
        if (EventCountCircuitBreaker.stateStrategy(abstractCircuitBreaker$State).isStateTransition(this, eventCountCircuitBreaker$CheckIntervalData2, eventCountCircuitBreaker$CheckIntervalData)) {
            abstractCircuitBreaker$State = abstractCircuitBreaker$State.oppositeState();
            this.changeStateAndStartNewCheckInterval(abstractCircuitBreaker$State);
        }
        return !EventCountCircuitBreaker.isOpen(abstractCircuitBreaker$State);
    }

    private boolean updateCheckIntervalData(EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData, EventCountCircuitBreaker$CheckIntervalData eventCountCircuitBreaker$CheckIntervalData2) {
        return eventCountCircuitBreaker$CheckIntervalData == eventCountCircuitBreaker$CheckIntervalData2 || this.checkIntervalData.compareAndSet(eventCountCircuitBreaker$CheckIntervalData, eventCountCircuitBreaker$CheckIntervalData2);
    }
}

