/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent.locks;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.apache.commons.lang3.concurrent.locks.LockingVisitors$1;
import org.apache.commons.lang3.concurrent.locks.LockingVisitors$LockVisitor$LVBuilder;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.Suppliers;

public class LockingVisitors$LockVisitor<O, L> {
    private final L lock;
    private final O object;
    private final Supplier<Lock> readLockSupplier;
    private final Supplier<Lock> writeLockSupplier;

    private LockingVisitors$LockVisitor(LockingVisitors$LockVisitor$LVBuilder<O, L, ?> lockingVisitors$LockVisitor$LVBuilder) {
        this.object = Objects.requireNonNull(lockingVisitors$LockVisitor$LVBuilder.object, "object");
        this.lock = Objects.requireNonNull(lockingVisitors$LockVisitor$LVBuilder.lock, "lock");
        this.readLockSupplier = Objects.requireNonNull(LockingVisitors$LockVisitor$LVBuilder.access$100(lockingVisitors$LockVisitor$LVBuilder), "readLockSupplier");
        this.writeLockSupplier = Objects.requireNonNull(LockingVisitors$LockVisitor$LVBuilder.access$200(lockingVisitors$LockVisitor$LVBuilder), "writeLockSupplier");
    }

    protected LockingVisitors$LockVisitor(O o2, L l2, Supplier<Lock> supplier, Supplier<Lock> supplier2) {
        this.object = Objects.requireNonNull(o2, "object");
        this.lock = Objects.requireNonNull(l2, "lock");
        this.readLockSupplier = Objects.requireNonNull(supplier, "readLockSupplier");
        this.writeLockSupplier = Objects.requireNonNull(supplier2, "writeLockSupplier");
    }

    public void acceptReadLocked(FailableConsumer<O, ?> failableConsumer) {
        LockingVisitors$LockVisitor lockingVisitors$LockVisitor = this;
        lockingVisitors$LockVisitor.lockAcceptUnlock(lockingVisitors$LockVisitor.readLockSupplier, failableConsumer);
    }

    public void acceptWriteLocked(FailableConsumer<O, ?> failableConsumer) {
        LockingVisitors$LockVisitor lockingVisitors$LockVisitor = this;
        lockingVisitors$LockVisitor.lockAcceptUnlock(lockingVisitors$LockVisitor.writeLockSupplier, failableConsumer);
    }

    public <T> T applyReadLocked(FailableFunction<O, T, ?> failableFunction) {
        LockingVisitors$LockVisitor lockingVisitors$LockVisitor = this;
        return lockingVisitors$LockVisitor.lockApplyUnlock(lockingVisitors$LockVisitor.readLockSupplier, failableFunction);
    }

    public <T> T applyWriteLocked(FailableFunction<O, T, ?> failableFunction) {
        LockingVisitors$LockVisitor lockingVisitors$LockVisitor = this;
        return lockingVisitors$LockVisitor.lockApplyUnlock(lockingVisitors$LockVisitor.writeLockSupplier, failableFunction);
    }

    public L getLock() {
        return this.lock;
    }

    public O getObject() {
        return this.object;
    }

    protected void lockAcceptUnlock(Supplier<Lock> object, FailableConsumer<O, ?> failableConsumer) {
        object = Objects.requireNonNull(Suppliers.get(object), "lock");
        object.lock();
        try {
            Failable.accept(failableConsumer, this.object);
            return;
        }
        finally {
            object.unlock();
        }
    }

    protected <T> T lockApplyUnlock(Supplier<Lock> object, FailableFunction<O, T, ?> failableFunction) {
        object = Objects.requireNonNull(Suppliers.get(object), "lock");
        object.lock();
        try {
            failableFunction = Failable.apply(failableFunction, this.object);
            return (T)failableFunction;
        }
        finally {
            object.unlock();
        }
    }

    /* synthetic */ LockingVisitors$LockVisitor(LockingVisitors$LockVisitor$LVBuilder lockingVisitors$LockVisitor$LVBuilder, LockingVisitors$1 lockingVisitors$1) {
        this(lockingVisitors$LockVisitor$LVBuilder);
    }
}

