/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ConstructorUtils {
    public static <T> Constructor<T> getAccessibleConstructor(Class<T> clazz, Class<?> ... classArray) {
        Objects.requireNonNull(clazz, "cls");
        try {
            return ConstructorUtils.getAccessibleConstructor(clazz.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> constructor) {
        Objects.requireNonNull(constructor, "ctor");
        if (MemberUtils.isAccessible(constructor) && ConstructorUtils.isAccessible(constructor.getDeclaringClass())) {
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> constructorArray, Class<?> ... classArray) {
        Objects.requireNonNull(constructorArray, "cls");
        try {
            return MemberUtils.setAccessibleWorkaround(constructorArray.getConstructor(classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?> constructor = null;
            Constructor<?>[] constructorArray2 = constructorArray.getConstructors();
            constructorArray = constructorArray2;
            constructorArray = constructorArray2;
            int n2 = constructorArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Constructor<?> constructor2 = constructorArray[i2];
                if (!MemberUtils.isMatchingConstructor(constructor2, classArray) || (constructor2 = ConstructorUtils.getAccessibleConstructor(constructor2)) == null) continue;
                MemberUtils.setAccessibleWorkaround(constructor2);
                if (constructor != null && MemberUtils.compareConstructorFit(constructor2, constructor, classArray) >= 0) continue;
                constructor = constructor2;
            }
            return constructor;
        }
    }

    public static <T> T invokeConstructor(Class<T> clazz, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        return ConstructorUtils.invokeConstructor(clazz, objectArray, ClassUtils.toClass(objectArray));
    }

    public static <T> T invokeConstructor(Class<T> clazz, Object[] objectArray, Class<?>[] object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        if ((object = ConstructorUtils.getMatchingAccessibleConstructor(clazz, ArrayUtils.nullToEmpty(object))) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        Object object2 = object;
        return ((Constructor)object2).newInstance(MethodUtils.toVarArgs(object2, objectArray));
    }

    public static <T> T invokeExactConstructor(Class<T> clazz, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        return ConstructorUtils.invokeExactConstructor(clazz, objectArray, ClassUtils.toClass(objectArray));
    }

    public static <T> T invokeExactConstructor(Class<T> clazz, Object[] objectArray, Class<?>[] object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if ((object = ConstructorUtils.getAccessibleConstructor(clazz, ArrayUtils.nullToEmpty(object))) == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return ((Constructor)object).newInstance(ArrayUtils.nullToEmpty(objectArray));
    }

    private static boolean isAccessible(Class<?> clazz) {
        while (clazz != null) {
            if (!ClassUtils.isPublic(clazz)) {
                return false;
            }
            clazz = clazz.getEnclosingClass();
        }
        return true;
    }

    @Deprecated
    public ConstructorUtils() {
    }
}

