/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ClassUtils$Interfaces;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.AccessibleObjects;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.stream.LangCollectors;

public class MethodUtils {
    private static final Comparator<Method> METHOD_BY_SIGNATURE = Comparator.comparing(Method::toString);

    private static int distance(Class<?>[] classArray, Class<?>[] classArray2) {
        int n2 = 0;
        if (!ClassUtils.isAssignable(classArray, classArray2, true)) {
            return -1;
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class<?> clazz = classArray[i2];
            Class<?> clazz2 = classArray2[i2];
            if (clazz == null || clazz.equals(clazz2)) continue;
            if (ClassUtils.isAssignable(clazz, clazz2, true) && !ClassUtils.isAssignable(clazz, clazz2, false)) {
                ++n2;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    public static Method getAccessibleMethod(Class<?> clazz, Method classArray) {
        if (!MemberUtils.isPublic((Member)classArray)) {
            return null;
        }
        if (ClassUtils.isPublic(clazz)) {
            return classArray;
        }
        String string = classArray.getName();
        Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = classArray.getParameterTypes());
        if (method != null) {
            return method;
        }
        return MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
    }

    public static Method getAccessibleMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        return MethodUtils.getAccessibleMethod(MethodUtils.getMethodObject(clazz, string, classArray));
    }

    public static Method getAccessibleMethod(Method method) {
        if (method != null) {
            return MethodUtils.getAccessibleMethod(method.getDeclaringClass(), method);
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            Class<?>[] classArray3 = classArray2;
            classArray3 = classArray2;
            int n2 = classArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                GenericDeclaration genericDeclaration = classArray3[i2];
                if (!ClassUtils.isPublic(genericDeclaration)) continue;
                try {
                    return genericDeclaration.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    genericDeclaration = MethodUtils.getAccessibleMethodFromInterfaceNest(genericDeclaration, string, classArray);
                    if (genericDeclaration == null) continue;
                    return genericDeclaration;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> clazz, String string, Class<?> ... classArray) {
        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!ClassUtils.isPublic(clazz)) continue;
            return MethodUtils.getMethodObject(clazz, string, classArray);
        }
        return null;
    }

    private static List<Class<?>> getAllSuperclassesAndInterfaces(Class<?> object) {
        if (object == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        List<Class<?>> list = ClassUtils.getAllSuperclasses(object);
        int n2 = 0;
        object = ClassUtils.getAllInterfaces(object);
        int n3 = 0;
        while (n3 < object.size() || n2 < list.size()) {
            Class clazz = n3 >= object.size() || n2 < list.size() && n2 < n3 ? list.get(n2++) : (Class)object.get(n3++);
            arrayList.add(clazz);
        }
        return arrayList;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> clazz, boolean bl2, boolean bl3) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(clazz, "annotationCls");
        if (!bl3 && !MemberUtils.isAccessible(method)) {
            return null;
        }
        A a2 = method.getAnnotation(clazz);
        if (a2 == null && bl2) {
            Iterator<Class<?>> iterator = method.getDeclaringClass();
            iterator = MethodUtils.getAllSuperclassesAndInterfaces(iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                GenericDeclaration genericDeclaration = iterator.next();
                genericDeclaration = bl3 ? MethodUtils.getMatchingMethod(genericDeclaration, method.getName(), method.getParameterTypes()) : MethodUtils.getMatchingAccessibleMethod(genericDeclaration, method.getName(), method.getParameterTypes());
                if (genericDeclaration == null || (a2 = ((Method)genericDeclaration).getAnnotation(clazz)) == null) continue;
            }
        }
        return a2;
    }

    private static Method getInvokeMethod(boolean bl2, String string, Class<?>[] classArray, Class<? extends Object> clazz) {
        Method method;
        if (bl2) {
            method = MethodUtils.getMatchingMethod(clazz, string, classArray);
            AccessibleObjects.setAccessible(method);
        } else {
            method = MethodUtils.getMatchingAccessibleMethod(clazz, string, classArray);
        }
        return method;
    }

    public static Method getMatchingAccessibleMethod(Class<?> object, String object2, Class<?> ... classArray) {
        GenericDeclaration genericDeclaration = MethodUtils.getMethodObject(object, (String)object2, classArray);
        if (genericDeclaration != null) {
            return MemberUtils.setAccessibleWorkaround(genericDeclaration);
        }
        object = ((Class)object).getMethods();
        object = Stream.of(object).filter(arg_0 -> MethodUtils.lambda$getMatchingAccessibleMethod$0((String)object2, classArray, arg_0)).collect(Collectors.toList());
        object.sort(METHOD_BY_SIGNATURE);
        object2 = null;
        object = object.iterator();
        while (object.hasNext()) {
            genericDeclaration = (Method)object.next();
            Method method = MethodUtils.getAccessibleMethod(genericDeclaration);
            if (method == null || object2 != null && MemberUtils.compareMethodFit(method, (Method)object2, classArray) >= 0) continue;
            object2 = method;
        }
        if (object2 != null) {
            MemberUtils.setAccessibleWorkaround(object2);
            if (((Method)object2).isVarArgs()) {
                object = ((Method)object2).getParameterTypes();
                genericDeclaration = object[((Object)object).length - 1].getComponentType();
                for (int i2 = ((Object)object).length - 1; i2 < classArray.length; ++i2) {
                    object = classArray[i2];
                    if (ClassUtils.isAssignable(object, genericDeclaration, true)) continue;
                    return null;
                }
            }
        }
        return object2;
    }

    public static Method getMatchingMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Object object2;
        Objects.requireNonNull(clazz, "cls");
        Validate.notEmpty(string, "methodName", new Object[0]);
        List list = Stream.of(clazz.getDeclaredMethods()).filter(method -> method.getName().equals(string)).collect(Collectors.toList());
        TreeMap treeMap = MethodUtils.getAllSuperclassesAndInterfaces(clazz);
        Collections.reverse(treeMap);
        treeMap.stream().map(Class::getDeclaredMethods).flatMap(Stream::of).filter(method -> method.getName().equals(string)).forEach(list::add);
        for (Object object2 : list) {
            if (!Arrays.deepEquals(((Method)object2).getParameterTypes(), classArray)) continue;
            return object2;
        }
        treeMap = new TreeMap();
        list.stream().filter(method -> ClassUtils.isAssignable(classArray, method.getParameterTypes(), true)).forEach(method -> {
            int n3 = MethodUtils.distance(classArray, method.getParameterTypes());
            List list = treeMap.computeIfAbsent(n3, n2 -> new ArrayList());
            list.add(method);
        });
        if (treeMap.isEmpty()) {
            return null;
        }
        object2 = (List)treeMap.values().iterator().next();
        if (object2.size() == 1 || !Objects.equals(((Method)object2.get(0)).getDeclaringClass(), ((Method)object2.get(1)).getDeclaringClass())) {
            return (Method)object2.get(0);
        }
        throw new IllegalStateException(String.format("Found multiple candidates for method %s on class %s : %s", string + Stream.of(classArray).map(String::valueOf).collect(Collectors.joining(",", "(", ")")), clazz.getName(), object2.stream().map(Method::toString).collect(Collectors.joining(",", "[", "]"))));
    }

    public static Method getMethodObject(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            if (string != null && clazz != null) {
                return clazz.getMethod(string, classArray);
            }
            return null;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return MethodUtils.getMethodsListWithAnnotation(clazz, clazz2, false, false);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> serializable, Class<? extends Annotation> clazz, boolean bl2, boolean bl3) {
        Objects.requireNonNull(serializable, "cls");
        Objects.requireNonNull(clazz, "annotationCls");
        ArrayList arrayList = bl2 ? MethodUtils.getAllSuperclassesAndInterfaces(serializable) : new ArrayList();
        arrayList.add(0, (Class<?>)serializable);
        serializable = new ArrayList();
        arrayList.forEach(clazz2 -> {
            Method[] methodArray = bl3 ? clazz2.getDeclaredMethods() : clazz2.getMethods();
            Stream.of(methodArray).filter(method -> method.isAnnotationPresent(clazz)).forEachOrdered(serializable::add);
        });
        return serializable;
    }

    public static Method[] getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return MethodUtils.getMethodsWithAnnotation(clazz, clazz2, false, false);
    }

    public static Method[] getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2, boolean bl2, boolean bl3) {
        return MethodUtils.getMethodsListWithAnnotation(clazz, clazz2, bl2, bl3).toArray(ArrayUtils.EMPTY_METHOD_ARRAY);
    }

    public static Set<Method> getOverrideHierarchy(Method method, ClassUtils$Interfaces object) {
        Objects.requireNonNull(method, "method");
        LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
        linkedHashSet.add(method);
        Object[] objectArray = method.getParameterTypes();
        Class<?> clazz = method.getDeclaringClass();
        object = ClassUtils.hierarchy(clazz, (ClassUtils$Interfaces)((Object)object)).iterator();
        object.next();
        block0: while (object.hasNext()) {
            GenericDeclaration genericDeclaration = (Class)object.next();
            if ((genericDeclaration = MethodUtils.getMatchingAccessibleMethod(genericDeclaration, method.getName(), objectArray)) == null) continue;
            if (Arrays.equals(((Method)genericDeclaration).getParameterTypes(), objectArray)) {
                linkedHashSet.add((Method)genericDeclaration);
                continue;
            }
            Map<TypeVariable<?>, Type> map = TypeUtils.getTypeArguments(clazz, ((Method)genericDeclaration).getDeclaringClass());
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Type type;
                Type type2 = TypeUtils.unrollVariables(map, method.getGenericParameterTypes()[i2]);
                if (!TypeUtils.equals(type2, type = TypeUtils.unrollVariables(map, ((Method)genericDeclaration).getGenericParameterTypes()[i2]))) continue block0;
            }
            linkedHashSet.add((Method)genericDeclaration);
        }
        return linkedHashSet;
    }

    public static Object invokeExactMethod(Object object, String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactMethod(object, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeExactMethod(Object object, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        return MethodUtils.invokeExactMethod(object, string, objectArray, ClassUtils.toClass(objectArray));
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Objects.requireNonNull(object, "object").getClass();
        classArray = ArrayUtils.nullToEmpty(classArray);
        Method method = MethodUtils.getAccessibleMethod(clazz, string, classArray);
        MethodUtils.requireNonNull(method, clazz, string, classArray);
        return method.invoke(object, ArrayUtils.nullToEmpty(objectArray));
    }

    public static Object invokeExactStaticMethod(Class<?> clazz, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        return MethodUtils.invokeExactStaticMethod(clazz, string, objectArray, ClassUtils.toClass(objectArray));
    }

    public static Object invokeExactStaticMethod(Class<?> clazz, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        classArray = ArrayUtils.nullToEmpty(classArray);
        Method method = MethodUtils.getAccessibleMethod(clazz, string, ArrayUtils.nullToEmpty(classArray));
        MethodUtils.requireNonNull(method, clazz, string, classArray);
        return method.invoke(null, ArrayUtils.nullToEmpty(objectArray));
    }

    public static Object invokeMethod(Object object, boolean bl2, String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, bl2, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, boolean bl2, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        return MethodUtils.invokeMethod(object, bl2, string, objectArray, ClassUtils.toClass(objectArray));
    }

    public static Object invokeMethod(Object object, boolean bl2, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Objects.requireNonNull(object, "object").getClass();
        classArray = ArrayUtils.nullToEmpty(classArray);
        Method method = MethodUtils.getInvokeMethod(bl2, string, classArray, clazz);
        MethodUtils.requireNonNull(method, clazz, string, classArray);
        return method.invoke(object, MethodUtils.toVarArgs(method, ArrayUtils.nullToEmpty(objectArray)));
    }

    public static Object invokeMethod(Object object, String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        return MethodUtils.invokeMethod(object, string, objectArray, ClassUtils.toClass(objectArray));
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod(object, false, string, objectArray, classArray);
    }

    public static Object invokeStaticMethod(Class<?> clazz, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        return MethodUtils.invokeStaticMethod(clazz, string, objectArray, ClassUtils.toClass(objectArray));
    }

    public static Object invokeStaticMethod(Class<?> clazz, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        classArray = ArrayUtils.nullToEmpty(classArray);
        Method method = MethodUtils.getMatchingAccessibleMethod(clazz, string, classArray);
        MethodUtils.requireNonNull(method, clazz, string, classArray);
        return method.invoke(null, MethodUtils.toVarArgs(method, ArrayUtils.nullToEmpty(objectArray)));
    }

    private static Method requireNonNull(Method method, Class<?> clazz, String string, Class<?>[] classArray) throws NoSuchMethodException {
        if (method == null) {
            throw new NoSuchMethodException(String.format("No method: %s.%s(%s)", clazz.getName(), string, Stream.of(classArray).map(Class::getName).collect(LangCollectors.joining(", "))));
        }
        return method;
    }

    static Object[] toVarArgs(Executable executable, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (executable.isVarArgs()) {
            return MethodUtils.toVarArgs(objectArray, executable.getParameterTypes());
        }
        return objectArray;
    }

    private static Object[] toVarArgs(Object[] objectArray, Class<?>[] object) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object[] objectArray2;
        int n2 = ((Class<?>[])object).length;
        if (objectArray.length == n2 && ((objectArray2 = objectArray[objectArray.length - 1]) == null || objectArray2.getClass().equals(object[n2 - 1]))) {
            return objectArray;
        }
        objectArray2 = ArrayUtils.arraycopy(objectArray, 0, 0, n2 - 1, () -> new Object[n2]);
        object = object[n2 - 1].getComponentType();
        Class<?> clazz = ClassUtils.primitiveToWrapper(object);
        int n3 = objectArray.length - n2 + 1;
        Object object2 = Array.newInstance(clazz, n3);
        boolean bl2 = ClassUtils.isPrimitiveOrWrapper(clazz);
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object3 = objectArray[n2 - 1 + i2];
            try {
                Array.set(object2, i2, bl2 ? clazz.getConstructor(ClassUtils.wrapperToPrimitive(clazz)).newInstance(object3) : clazz.cast(object3));
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalArgumentException("Cannot convert vararg #" + i2, instantiationException);
            }
        }
        if (((Class)object).isPrimitive()) {
            object2 = ArrayUtils.toPrimitive(object2);
        }
        objectArray2[n2 - 1] = object2;
        return objectArray2;
    }

    @Deprecated
    public MethodUtils() {
    }

    private static /* synthetic */ boolean lambda$getMatchingAccessibleMethod$0(String string, Class[] classArray, Method method) {
        return method.getName().equals(string) && MemberUtils.isMatchingMethod(method, classArray);
    }
}

