/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.AppendableJoiner;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.TypeUtils$GenericArrayTypeImpl;
import org.apache.commons.lang3.reflect.TypeUtils$ParameterizedTypeImpl;
import org.apache.commons.lang3.reflect.TypeUtils$WildcardTypeBuilder;
import org.apache.commons.lang3.reflect.Typed;

public class TypeUtils {
    private static final AppendableJoiner<Type> AMP_JOINER = AppendableJoiner.builder().setDelimiter(" & ").setElementAppender((appendable, type) -> appendable.append(TypeUtils.toString(type))).get();
    private static final AppendableJoiner<TypeVariable<Class<?>>> CTJ_JOINER = AppendableJoiner.builder().setDelimiter(", ").setElementAppender((appendable, typeVariable) -> appendable.append(TypeUtils.anyToString(typeVariable))).get();
    private static final AppendableJoiner<Object> GT_JOINER = AppendableJoiner.builder().setPrefix("<").setSuffix(">").setDelimiter(", ").setElementAppender((appendable, object) -> appendable.append(TypeUtils.anyToString(object))).get();
    public static final WildcardType WILDCARD_ALL = TypeUtils.wildcardType().withUpperBounds(new Type[]{Object.class}).build();

    private static <T> String anyToString(T t2) {
        if (t2 instanceof Type) {
            return TypeUtils.toString((Type)t2);
        }
        return t2.toString();
    }

    private static void appendRecursiveTypes(StringBuilder stringBuilder, int[] nArray, Type[] typeArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            GT_JOINER.join(stringBuilder, (Object[])new Object[]{typeArray[i2].toString()});
        }
        Type[] typeArray2 = ArrayUtils.removeAll(typeArray, nArray);
        if (typeArray2.length > 0) {
            GT_JOINER.join(stringBuilder, (Object[])typeArray2);
        }
    }

    private static <T> String classToString(Class<T> clazz) {
        if (clazz.isArray()) {
            return TypeUtils.toString(clazz.getComponentType()) + "[]";
        }
        if (TypeUtils.isCyclical(clazz)) {
            return clazz.getSimpleName() + "(cycle)";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (clazz.getEnclosingClass() != null) {
            stringBuilder.append(TypeUtils.classToString(clazz.getEnclosingClass())).append('.').append(clazz.getSimpleName());
        } else {
            stringBuilder.append(clazz.getName());
        }
        if (clazz.getTypeParameters().length > 0) {
            CTJ_JOINER.join(stringBuilder, clazz.getTypeParameters());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsTypeVariables(Type object) {
        while (true) {
            void var0_1;
            if (var0_1 instanceof TypeVariable) {
                return true;
            }
            if (var0_1 instanceof Class) {
                return ((Class)var0_1).getTypeParameters().length > 0;
            }
            if (var0_1 instanceof ParameterizedType) {
                for (Type type : ((ParameterizedType)var0_1).getActualTypeArguments()) {
                    if (!TypeUtils.containsTypeVariables(type)) continue;
                    return true;
                }
                return false;
            }
            if (var0_1 instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)var0_1;
                return TypeUtils.containsTypeVariables(TypeUtils.getImplicitLowerBounds(wildcardType)[0]) || TypeUtils.containsTypeVariables(TypeUtils.getImplicitUpperBounds(wildcardType)[0]);
            }
            if (!(var0_1 instanceof GenericArrayType)) break;
            Type type = ((GenericArrayType)var0_1).getGenericComponentType();
        }
        return false;
    }

    private static boolean containsVariableTypeSameParametrizedTypeBound(TypeVariable<?> typeVariable, ParameterizedType parameterizedType) {
        return ArrayUtils.contains(typeVariable.getBounds(), parameterizedType);
    }

    public static Map<TypeVariable<?>, Type> determineTypeArguments(Class<?> clazz, ParameterizedType object) {
        Type type;
        while (true) {
            Objects.requireNonNull(clazz, "cls");
            Objects.requireNonNull(object, "superParameterizedType");
            type = TypeUtils.getRawType((ParameterizedType)object);
            if (!TypeUtils.isAssignable(clazz, type)) {
                return null;
            }
            if (clazz.equals(type)) {
                return TypeUtils.getTypeArguments((ParameterizedType)object, type, null);
            }
            if (!((type = TypeUtils.getClosestParentType(clazz, type)) instanceof Class)) break;
            clazz = type;
        }
        type = (ParameterizedType)type;
        Class<?> clazz2 = TypeUtils.getRawType((ParameterizedType)type);
        object = TypeUtils.determineTypeArguments(clazz2, (ParameterizedType)object);
        TypeUtils.mapTypeVariablesToArguments(clazz, type, object);
        return object;
    }

    private static boolean equals(GenericArrayType genericArrayType, Type type) {
        return type instanceof GenericArrayType && TypeUtils.equals(genericArrayType.getGenericComponentType(), ((GenericArrayType)type).getGenericComponentType());
    }

    private static boolean equals(ParameterizedType parameterizedType, Type type) {
        if (type instanceof ParameterizedType) {
            type = (ParameterizedType)type;
            if (TypeUtils.equals(parameterizedType.getRawType(), type.getRawType()) && TypeUtils.equals(parameterizedType.getOwnerType(), type.getOwnerType())) {
                return TypeUtils.equals(parameterizedType.getActualTypeArguments(), type.getActualTypeArguments());
            }
        }
        return false;
    }

    public static boolean equals(Type type, Type type2) {
        if (Objects.equals(type, type2)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.equals((ParameterizedType)type, type2);
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.equals((GenericArrayType)type, type2);
        }
        if (type instanceof WildcardType) {
            return TypeUtils.equals((WildcardType)type, type2);
        }
        return false;
    }

    private static boolean equals(Type[] typeArray, Type[] typeArray2) {
        if (typeArray.length == typeArray2.length) {
            for (int i2 = 0; i2 < typeArray.length; ++i2) {
                if (TypeUtils.equals(typeArray[i2], typeArray2[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean equals(WildcardType wildcardType, Type type) {
        if (type instanceof WildcardType) {
            type = (WildcardType)type;
            return TypeUtils.equals(TypeUtils.getImplicitLowerBounds(wildcardType), TypeUtils.getImplicitLowerBounds((WildcardType)type)) && TypeUtils.equals(TypeUtils.getImplicitUpperBounds(wildcardType), TypeUtils.getImplicitUpperBounds((WildcardType)type));
        }
        return false;
    }

    private static Type[] extractTypeArgumentsFrom(Map<TypeVariable<?>, Type> map, TypeVariable<?>[] typeVariableArray) {
        Type[] typeArray = new Type[typeVariableArray.length];
        int n2 = 0;
        for (TypeVariable<?> typeVariable : typeVariableArray) {
            Validate.isTrue(map.containsKey(typeVariable), () -> String.format("missing argument mapping for %s", TypeUtils.toString(typeVariable)));
            typeArray[n2++] = map.get(typeVariable);
        }
        return typeArray;
    }

    private static int[] findRecursiveTypes(ParameterizedType parameterizedType) {
        Type[] typeArray = Arrays.copyOf(parameterizedType.getActualTypeArguments(), parameterizedType.getActualTypeArguments().length);
        int[] nArray = new int[]{};
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            if (!(typeArray[i2] instanceof TypeVariable) || !TypeUtils.containsVariableTypeSameParametrizedTypeBound((TypeVariable)typeArray[i2], parameterizedType)) continue;
            nArray = ArrayUtils.add(nArray, i2);
        }
        return nArray;
    }

    public static GenericArrayType genericArrayType(Type type) {
        return new TypeUtils$GenericArrayTypeImpl(Objects.requireNonNull(type, "componentType"), null);
    }

    private static String genericArrayTypeToString(GenericArrayType genericArrayType) {
        return String.format("%s[]", TypeUtils.toString(genericArrayType.getGenericComponentType()));
    }

    public static Type getArrayComponentType(Type type) {
        if (type instanceof Class) {
            if (((Class)(type = (Class)type)).isArray()) {
                return ((Class)type).getComponentType();
            }
            return null;
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return null;
    }

    private static Type getClosestParentType(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isInterface()) {
            Type[] typeArray = clazz.getGenericInterfaces();
            Type type = null;
            for (Type type2 : typeArray) {
                Class clazz3;
                if (type2 instanceof ParameterizedType) {
                    clazz3 = TypeUtils.getRawType((ParameterizedType)type2);
                } else if (type2 instanceof Class) {
                    clazz3 = (Class)type2;
                } else {
                    throw new IllegalStateException("Unexpected generic interface type found: " + type2);
                }
                if (!TypeUtils.isAssignable((Type)clazz3, clazz2) || !TypeUtils.isAssignable(type, (Type)clazz3)) continue;
                type = type2;
            }
            if (type != null) {
                return type;
            }
        }
        return clazz.getGenericSuperclass();
    }

    public static Type[] getImplicitBounds(TypeVariable<?> typeVariable) {
        return TypeUtils.normalizeUpperToObject(Objects.requireNonNull(typeVariable, "typeVariable").getBounds());
    }

    public static Type[] getImplicitLowerBounds(WildcardType typeArray) {
        Objects.requireNonNull(typeArray, "wildcardType");
        typeArray = typeArray.getLowerBounds();
        if (typeArray.length == 0) {
            return new Type[]{null};
        }
        return typeArray;
    }

    public static Type[] getImplicitUpperBounds(WildcardType wildcardType) {
        return TypeUtils.normalizeUpperToObject(Objects.requireNonNull(wildcardType, "wildcardType").getUpperBounds());
    }

    private static Class<?> getRawType(ParameterizedType type) {
        if (!((type = type.getRawType()) instanceof Class)) {
            throw new IllegalStateException("Type of rawType: " + type);
        }
        return (Class)type;
    }

    public static Class<?> getRawType(Type type, Type type2) {
        Object object;
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.getRawType((ParameterizedType)type);
            }
            if (!(type instanceof TypeVariable)) break;
            if (type2 == null) {
                return null;
            }
            object = ((TypeVariable)type).getGenericDeclaration();
            if (!(object instanceof Class)) {
                return null;
            }
            if ((object = TypeUtils.getTypeArguments(type2, (Class)object)) == null) {
                return null;
            }
            if ((type = (Type)object.get(type)) != null) continue;
            return null;
        }
        if (type instanceof GenericArrayType) {
            object = TypeUtils.getRawType(((GenericArrayType)type).getGenericComponentType(), type2);
            if (object != null) {
                return Array.newInstance(object, 0).getClass();
            }
            return null;
        }
        if (type instanceof WildcardType) {
            return null;
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(Class<?> clazz, Class<?> clazz2, Map<TypeVariable<?>, Type> map) {
        if (!TypeUtils.isAssignable(clazz, clazz2)) {
            return null;
        }
        if (clazz.isPrimitive()) {
            if (clazz2.isPrimitive()) {
                return new HashMap();
            }
            clazz = ClassUtils.primitiveToWrapper(clazz);
        }
        Map<TypeVariable<?>, Type> map2 = map = map == null ? new HashMap() : new HashMap(map);
        if (clazz2.equals(clazz)) {
            return map;
        }
        return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(clazz, clazz2), clazz2, map);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType) {
        ParameterizedType parameterizedType2 = parameterizedType;
        return TypeUtils.getTypeArguments(parameterizedType2, TypeUtils.getRawType(parameterizedType2), null);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType typeVariableArray, Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        Map<TypeVariable<?>, Type> map2;
        Class<?> clazz2 = TypeUtils.getRawType((ParameterizedType)typeVariableArray);
        if (!TypeUtils.isAssignable(clazz2, clazz)) {
            return null;
        }
        Type[] typeArray = typeVariableArray.getOwnerType();
        if (typeArray instanceof ParameterizedType) {
            typeArray = (ParameterizedType)typeArray;
            map2 = TypeUtils.getTypeArguments((ParameterizedType)typeArray, TypeUtils.getRawType((ParameterizedType)typeArray), map);
        } else {
            map2 = map == null ? new HashMap() : new HashMap(map);
        }
        map = map2;
        typeArray = typeVariableArray.getActualTypeArguments();
        typeVariableArray = clazz2.getTypeParameters();
        for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
            Type type;
            Type type2 = type = typeArray[i2];
            map.put(typeVariableArray[i2], map.getOrDefault(type2, type2));
        }
        if (clazz.equals(clazz2)) {
            return map;
        }
        return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(clazz2, clazz), clazz, map);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> clazz) {
        return TypeUtils.getTypeArguments(type, clazz, null);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(Type object, Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        block7: {
            block0: while (true) {
                Type type;
                int n2;
                int n3;
                if (object instanceof Class) {
                    return TypeUtils.getTypeArguments((Class)object, clazz, map);
                }
                if (object instanceof ParameterizedType) {
                    return TypeUtils.getTypeArguments((ParameterizedType)object, clazz, map);
                }
                if (object instanceof GenericArrayType) {
                    clazz = clazz.isArray() ? clazz.getComponentType() : clazz;
                    object = ((GenericArrayType)object).getGenericComponentType();
                    continue;
                }
                if (object instanceof WildcardType) {
                    object = TypeUtils.getImplicitUpperBounds((WildcardType)object);
                    n3 = ((Type[])object).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        type = object[n2];
                        if (!TypeUtils.isAssignable(type, clazz)) continue;
                        object = type;
                        continue block0;
                    }
                    return null;
                }
                if (!(object instanceof TypeVariable)) break block7;
                object = TypeUtils.getImplicitBounds((TypeVariable)object);
                n3 = ((Type[])object).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    type = object[n2];
                    if (!TypeUtils.isAssignable(type, clazz)) continue;
                    object = type;
                    continue block0;
                }
                break;
            }
            return null;
        }
        throw new IllegalStateException("found an unhandled type: " + object);
    }

    public static boolean isArrayType(Type type) {
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
    }

    private static boolean isAssignable(Type typeArray, Class<?> clazz) {
        while (true) {
            if (typeArray == null) {
                return clazz == null || !clazz.isPrimitive();
            }
            if (clazz == null) {
                return false;
            }
            if (clazz.equals(typeArray)) {
                return true;
            }
            if (typeArray instanceof Class) {
                return ClassUtils.isAssignable((Class)typeArray, clazz);
            }
            if (!(typeArray instanceof ParameterizedType)) break;
            typeArray = TypeUtils.getRawType((ParameterizedType)typeArray);
        }
        if (typeArray instanceof TypeVariable) {
            for (Type type : ((TypeVariable)typeArray).getBounds()) {
                if (!TypeUtils.isAssignable(type, clazz)) continue;
                return true;
            }
            return false;
        }
        if (typeArray instanceof GenericArrayType) {
            return clazz.equals(Object.class) || clazz.isArray() && TypeUtils.isAssignable(((GenericArrayType)typeArray).getGenericComponentType(), clazz.getComponentType());
        }
        if (typeArray instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + typeArray);
    }

    private static boolean isAssignable(Type typeArray, GenericArrayType genericArrayType, Map<TypeVariable<?>, Type> map) {
        if (typeArray == null) {
            return true;
        }
        if (genericArrayType == null) {
            return false;
        }
        if (genericArrayType.equals(typeArray)) {
            return true;
        }
        Type type = genericArrayType.getGenericComponentType();
        if (typeArray instanceof Class) {
            return (typeArray = (Class)typeArray).isArray() && TypeUtils.isAssignable(typeArray.getComponentType(), type, map);
        }
        if (typeArray instanceof GenericArrayType) {
            return TypeUtils.isAssignable(((GenericArrayType)typeArray).getGenericComponentType(), type, map);
        }
        if (typeArray instanceof WildcardType) {
            for (Type type2 : TypeUtils.getImplicitUpperBounds((WildcardType)typeArray)) {
                if (!TypeUtils.isAssignable(type2, genericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (typeArray instanceof TypeVariable) {
            for (Type type3 : TypeUtils.getImplicitBounds((TypeVariable)typeArray)) {
                if (!TypeUtils.isAssignable(type3, genericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (typeArray instanceof ParameterizedType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + typeArray);
    }

    private static boolean isAssignable(Type object, ParameterizedType object2, Map<TypeVariable<?>, Type> map) {
        if (object == null) {
            return true;
        }
        if (object2 == null) {
            return false;
        }
        if (object instanceof GenericArrayType) {
            return false;
        }
        if (((Object)object2).equals(object)) {
            return true;
        }
        Class<?> clazz = TypeUtils.getRawType((ParameterizedType)((Object)object2));
        if ((object = TypeUtils.getTypeArguments((Type)((Object)object), clazz, null)) == null) {
            return false;
        }
        if (object.isEmpty()) {
            return true;
        }
        object2 = TypeUtils.getTypeArguments((ParameterizedType)((Object)object2), clazz, map);
        for (TypeVariable typeVariable : object2.keySet()) {
            Type type = TypeUtils.unrollVariableAssignments(typeVariable, object2);
            Type type2 = TypeUtils.unrollVariableAssignments(typeVariable, object);
            if (type == null && type2 instanceof Class || type2 == null || type == null || type.equals(type2) || type instanceof WildcardType && TypeUtils.isAssignable(type2, type, map)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Type type, Type type2) {
        return TypeUtils.isAssignable(type, type2, null);
    }

    private static boolean isAssignable(Type type, Type type2, Map<TypeVariable<?>, Type> map) {
        if (type2 == null || type2 instanceof Class) {
            return TypeUtils.isAssignable(type, (Class)type2);
        }
        if (type2 instanceof ParameterizedType) {
            return TypeUtils.isAssignable(type, (ParameterizedType)type2, map);
        }
        if (type2 instanceof GenericArrayType) {
            return TypeUtils.isAssignable(type, (GenericArrayType)type2, map);
        }
        if (type2 instanceof WildcardType) {
            return TypeUtils.isAssignable(type, (WildcardType)type2, map);
        }
        if (type2 instanceof TypeVariable) {
            return TypeUtils.isAssignable(type, (TypeVariable)type2, map);
        }
        throw new IllegalStateException("found an unhandled type: " + type2);
    }

    private static boolean isAssignable(Type type, TypeVariable<?> typeVariable, Map<TypeVariable<?>, Type> map) {
        if (type == null) {
            return true;
        }
        if (typeVariable == null) {
            return false;
        }
        if (typeVariable.equals(type)) {
            return true;
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray = TypeUtils.getImplicitBounds((TypeVariable)type);
            Type[] typeArray2 = typeArray;
            typeArray2 = typeArray;
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Type type2 = typeArray2[i2];
                if (!TypeUtils.isAssignable(type2, typeVariable, map)) continue;
                return true;
            }
        }
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType || type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static boolean isAssignable(Type type, WildcardType typeArray, Map<TypeVariable<?>, Type> map) {
        int n2;
        if (type == null) {
            return true;
        }
        if (typeArray == null) {
            return false;
        }
        if (typeArray.equals(type)) {
            return true;
        }
        Type[] object = TypeUtils.getImplicitUpperBounds((WildcardType)typeArray);
        typeArray = TypeUtils.getImplicitLowerBounds((WildcardType)typeArray);
        if (type instanceof WildcardType) {
            Type type2;
            int n3;
            int n4;
            Type[] typeArray2;
            Type type3;
            int n5;
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray3 = TypeUtils.getImplicitUpperBounds(wildcardType);
            Type[] typeArray4 = TypeUtils.getImplicitLowerBounds(wildcardType);
            Type[] typeArray5 = object;
            int n52 = object.length;
            for (n5 = 0; n5 < n52; ++n5) {
                type3 = typeArray5[n5];
                type3 = TypeUtils.substituteTypeVariables(type3, map);
                typeArray2 = typeArray3;
                n4 = typeArray3.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    type2 = typeArray2[n3];
                    if (TypeUtils.isAssignable(type2, type3, map)) continue;
                    return false;
                }
            }
            Type[] typeArray6 = typeArray;
            n52 = typeArray.length;
            for (n5 = 0; n5 < n52; ++n5) {
                type3 = typeArray6[n5];
                type3 = TypeUtils.substituteTypeVariables(type3, map);
                typeArray2 = typeArray4;
                n4 = typeArray4.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    type2 = typeArray2[n3];
                    if (TypeUtils.isAssignable(type3, type2, map)) continue;
                    return false;
                }
            }
            return true;
        }
        Type[] typeArray7 = object;
        int n6 = object.length;
        for (n2 = 0; n2 < n6; ++n2) {
            Type type4 = typeArray7[n2];
            if (TypeUtils.isAssignable(type, TypeUtils.substituteTypeVariables(type4, map), map)) continue;
            return false;
        }
        typeArray7 = typeArray;
        n6 = typeArray.length;
        for (n2 = 0; n2 < n6; ++n2) {
            Type type5 = typeArray7[n2];
            if (TypeUtils.isAssignable(TypeUtils.substituteTypeVariables(type5, map), type, map)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCyclical(Class<?> clazz) {
        for (TypeVariable<Class<?>> typeVariable : clazz.getTypeParameters()) {
            for (Type type : typeVariable.getBounds()) {
                if (!type.getTypeName().contains(clazz.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInstance(Object object, Type type) {
        if (type == null) {
            return false;
        }
        if (object == null) {
            return !(type instanceof Class) || !((Class)type).isPrimitive();
        }
        return TypeUtils.isAssignable(object.getClass(), type, null);
    }

    private static <T> void mapTypeVariablesToArguments(Class<T> object, ParameterizedType typeVariableArray, Map<TypeVariable<?>, Type> map) {
        Type[] typeArray = typeVariableArray.getOwnerType();
        if (typeArray instanceof ParameterizedType) {
            TypeUtils.mapTypeVariablesToArguments(object, (ParameterizedType)typeArray, map);
        }
        typeArray = typeVariableArray.getActualTypeArguments();
        typeVariableArray = TypeUtils.getRawType((ParameterizedType)typeVariableArray).getTypeParameters();
        object = Arrays.asList(((Class)object).getTypeParameters());
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            TypeVariable<Class<?>> typeVariable = typeVariableArray[i2];
            Type type = typeArray[i2];
            if (!object.contains(type) || !map.containsKey(typeVariable)) continue;
            map.put((TypeVariable)type, map.get(typeVariable));
        }
    }

    public static Type[] normalizeUpperBounds(Type[] typeArray) {
        Objects.requireNonNull(typeArray, "bounds");
        if (typeArray.length < 2) {
            return typeArray;
        }
        HashSet<Type> hashSet = new HashSet<Type>(typeArray.length);
        Type[] typeArray2 = typeArray;
        int n2 = typeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type = typeArray2[i2];
            boolean bl2 = false;
            Type[] typeArray3 = typeArray;
            int n3 = typeArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Type type2 = typeArray3[i3];
                if (type == type2 || !TypeUtils.isAssignable(type2, type, null)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            hashSet.add(type);
        }
        return hashSet.toArray(ArrayUtils.EMPTY_TYPE_ARRAY);
    }

    private static Type[] normalizeUpperToObject(Type[] typeArray) {
        if (typeArray.length == 0) {
            return new Type[]{Object.class};
        }
        return TypeUtils.normalizeUpperBounds(typeArray);
    }

    public static final ParameterizedType parameterize(Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        Objects.requireNonNull(clazz, "rawClass");
        Objects.requireNonNull(map, "typeVariableMap");
        return TypeUtils.parameterizeWithOwner(null, clazz, TypeUtils.extractTypeArgumentsFrom(map, clazz.getTypeParameters()));
    }

    public static final ParameterizedType parameterize(Class<?> clazz, Type ... typeArray) {
        return TypeUtils.parameterizeWithOwner(null, clazz, typeArray);
    }

    private static String parameterizedTypeToString(ParameterizedType parameterizedType) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = parameterizedType.getOwnerType();
        Class clazz = (Class)parameterizedType.getRawType();
        if (object == null) {
            stringBuilder.append(clazz.getName());
        } else {
            if (object instanceof Class) {
                stringBuilder.append(((Class)object).getName());
            } else {
                stringBuilder.append(object);
            }
            stringBuilder.append('.').append(clazz.getSimpleName());
        }
        int[] nArray = TypeUtils.findRecursiveTypes(parameterizedType);
        object = nArray;
        if (nArray.length > 0) {
            TypeUtils.appendRecursiveTypes(stringBuilder, (int[])object, parameterizedType.getActualTypeArguments());
        } else {
            GT_JOINER.join(stringBuilder, (Object[])parameterizedType.getActualTypeArguments());
        }
        return stringBuilder.toString();
    }

    public static final ParameterizedType parameterizeWithOwner(Type type, Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        Objects.requireNonNull(clazz, "rawClass");
        Objects.requireNonNull(map, "typeVariableMap");
        return TypeUtils.parameterizeWithOwner(type, clazz, TypeUtils.extractTypeArgumentsFrom(map, clazz.getTypeParameters()));
    }

    public static final ParameterizedType parameterizeWithOwner(Type clazz, Class<?> clazz2, Type ... typeArray) {
        Objects.requireNonNull(clazz2, "rawClass");
        if (clazz2.getEnclosingClass() == null) {
            Validate.isTrue(clazz == null, "no owner allowed for top-level %s", clazz2);
            clazz = null;
        } else if (clazz == null) {
            clazz = clazz2.getEnclosingClass();
        } else {
            Validate.isTrue(TypeUtils.isAssignable(clazz, clazz2.getEnclosingClass()), "%s is invalid owner type for parameterized %s", clazz, clazz2);
        }
        Validate.noNullElements(typeArray, "null type argument at index %s", new Object[0]);
        Validate.isTrue(clazz2.getTypeParameters().length == typeArray.length, "invalid number of type parameters specified: expected %d, got %d", clazz2.getTypeParameters().length, typeArray.length);
        return new TypeUtils$ParameterizedTypeImpl(clazz2, clazz, typeArray, null);
    }

    private static Type substituteTypeVariables(Type type, Map<TypeVariable<?>, Type> object) {
        if (type instanceof TypeVariable && object != null) {
            if ((object = object.get(type)) == null) {
                throw new IllegalArgumentException("missing assignment type for type variable " + type);
            }
            return object;
        }
        return type;
    }

    public static String toLongString(TypeVariable<?> typeVariable) {
        StringBuilder stringBuilder;
        block5: {
            Objects.requireNonNull(typeVariable, "typeVariable");
            stringBuilder = new StringBuilder();
            Object object = typeVariable.getGenericDeclaration();
            if (object instanceof Class) {
                object = (Class)object;
                while (true) {
                    if (((Class)object).getEnclosingClass() == null) {
                        stringBuilder.insert(0, ((Class)object).getName());
                        break block5;
                    }
                    stringBuilder.insert(0, ((Class)object).getSimpleName()).insert(0, '.');
                    object = ((Class)object).getEnclosingClass();
                }
            }
            if (object instanceof Type) {
                stringBuilder.append(TypeUtils.toString((Type)object));
            } else {
                stringBuilder.append(object);
            }
        }
        return stringBuilder.append(':').append(TypeUtils.typeVariableToString(typeVariable)).toString();
    }

    public static String toString(Type type) {
        Objects.requireNonNull(type, "type");
        if (type instanceof Class) {
            return TypeUtils.classToString((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.parameterizedTypeToString((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return TypeUtils.wildcardTypeToString((WildcardType)type);
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.typeVariableToString((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.genericArrayTypeToString((GenericArrayType)type);
        }
        throw new IllegalArgumentException(ObjectUtils.identityToString(type));
    }

    public static boolean typesSatisfyVariables(Map<TypeVariable<?>, Type> map) {
        Objects.requireNonNull(map, "typeVariableMap");
        for (Map.Entry<TypeVariable<?>, Type> entry : map.entrySet()) {
            Type[] typeArray = entry.getKey();
            Type object = entry.getValue();
            for (Type type : TypeUtils.getImplicitBounds(typeArray)) {
                if (TypeUtils.isAssignable(object, TypeUtils.substituteTypeVariables(type, map), map)) continue;
                return false;
            }
        }
        return true;
    }

    private static String typeVariableToString(TypeVariable<?> typeArray) {
        StringBuilder stringBuilder = new StringBuilder(typeArray.getName());
        if (!((typeArray = typeArray.getBounds()).length <= 0 || typeArray.length == 1 && Object.class.equals((Object)typeArray[0]))) {
            Type type = typeArray[0];
            boolean bl2 = true;
            if (type instanceof ParameterizedType && (type = ((ParameterizedType)type).getRawType()) instanceof Class && ((Class)type).isInterface()) {
                bl2 = false;
            }
            if (bl2) {
                stringBuilder.append(" extends ");
                AMP_JOINER.join(stringBuilder, (Type[])typeArray);
            }
        }
        return stringBuilder.toString();
    }

    private static Type[] unrollBounds(Map<TypeVariable<?>, Type> map, Type[] typeArray) {
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            Type type = TypeUtils.unrollVariables(map, typeArray[i2]);
            if (type == null) {
                typeArray = ArrayUtils.remove(typeArray, i2--);
                continue;
            }
            typeArray[i2] = type;
        }
        return typeArray;
    }

    private static Type unrollVariableAssignments(TypeVariable<?> typeVariable, Map<TypeVariable<?>, Type> map) {
        Type type;
        while ((type = map.get(typeVariable)) instanceof TypeVariable && !type.equals(typeVariable)) {
            typeVariable = (TypeVariable)type;
        }
        return type;
    }

    public static Type unrollVariables(Map<TypeVariable<?>, Type> map, Type type) {
        block6: {
            while (true) {
                if (map == null) {
                    map = Collections.emptyMap();
                }
                if (!TypeUtils.containsTypeVariables(type)) break block6;
                if (!(type instanceof TypeVariable)) break;
                type = map.get(type);
            }
            if (type instanceof ParameterizedType) {
                if ((type = (ParameterizedType)type).getOwnerType() != null) {
                    map = new HashMap<TypeVariable<Object>, Type>(map);
                    map.putAll(TypeUtils.getTypeArguments((ParameterizedType)type));
                }
                Type[] typeArray = type.getActualTypeArguments();
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    Type type2 = TypeUtils.unrollVariables(map, typeArray[i2]);
                    if (type2 == null) continue;
                    typeArray[i2] = type2;
                }
                return TypeUtils.parameterizeWithOwner(type.getOwnerType(), (Class)type.getRawType(), typeArray);
            }
            if (type instanceof WildcardType) {
                type = (WildcardType)type;
                return TypeUtils.wildcardType().withUpperBounds(TypeUtils.unrollBounds(map, type.getUpperBounds())).withLowerBounds(TypeUtils.unrollBounds(map, type.getLowerBounds())).build();
            }
        }
        return type;
    }

    public static TypeUtils$WildcardTypeBuilder wildcardType() {
        return new TypeUtils$WildcardTypeBuilder(null);
    }

    private static String wildcardTypeToString(WildcardType typeArray) {
        StringBuilder stringBuilder = new StringBuilder("?");
        Type[] typeArray2 = typeArray.getLowerBounds();
        typeArray = typeArray.getUpperBounds();
        if (typeArray2.length > 1 || typeArray2.length == 1 && typeArray2[0] != null) {
            AMP_JOINER.join(stringBuilder.append(" super "), (Type[])typeArray2);
        } else if (typeArray.length > 1 || typeArray.length == 1 && !Object.class.equals((Object)typeArray[0])) {
            AMP_JOINER.join(stringBuilder.append(" extends "), (Type[])typeArray);
        }
        return stringBuilder.toString();
    }

    public static <T> Typed<T> wrap(Class<T> clazz) {
        return TypeUtils.wrap(clazz);
    }

    public static <T> Typed<T> wrap(Type type) {
        return () -> type;
    }

    @Deprecated
    public TypeUtils() {
    }

    static /* synthetic */ boolean access$000(GenericArrayType genericArrayType, Type type) {
        return TypeUtils.equals(genericArrayType, type);
    }

    static /* synthetic */ boolean access$100(ParameterizedType parameterizedType, Type type) {
        return TypeUtils.equals(parameterizedType, type);
    }

    static /* synthetic */ boolean access$300(WildcardType wildcardType, Type type) {
        return TypeUtils.equals(wildcardType, type);
    }
}

