/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.stream;

import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.commons.lang3.function.Failable;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailablePredicate;

public class Streams$FailableStream<T> {
    private Stream<T> stream;
    private boolean terminated;

    public Streams$FailableStream(Stream<T> stream) {
        this.stream = stream;
    }

    public boolean allMatch(FailablePredicate<T, ?> failablePredicate) {
        this.assertNotTerminated();
        return this.stream().allMatch(Failable.asPredicate(failablePredicate));
    }

    public boolean anyMatch(FailablePredicate<T, ?> failablePredicate) {
        this.assertNotTerminated();
        return this.stream().anyMatch(Failable.asPredicate(failablePredicate));
    }

    protected void assertNotTerminated() {
        if (this.terminated) {
            throw new IllegalStateException("This stream is already terminated.");
        }
    }

    public <A, R> R collect(Collector<? super T, A, R> collector) {
        this.makeTerminated();
        return this.stream().collect(collector);
    }

    public <A, R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> biConsumer, BiConsumer<R, R> biConsumer2) {
        this.makeTerminated();
        return this.stream().collect(supplier, biConsumer, biConsumer2);
    }

    public Streams$FailableStream<T> filter(FailablePredicate<T, ?> failablePredicate) {
        this.assertNotTerminated();
        this.stream = this.stream.filter(Failable.asPredicate(failablePredicate));
        return this;
    }

    public void forEach(FailableConsumer<T, ?> failableConsumer) {
        this.makeTerminated();
        this.stream().forEach(Failable.asConsumer(failableConsumer));
    }

    protected void makeTerminated() {
        this.assertNotTerminated();
        this.terminated = true;
    }

    public <R> Streams$FailableStream<R> map(FailableFunction<T, R, ?> failableFunction) {
        this.assertNotTerminated();
        return new Streams$FailableStream<R>(this.stream.map(Failable.asFunction(failableFunction)));
    }

    public T reduce(T t2, BinaryOperator<T> binaryOperator) {
        this.makeTerminated();
        return this.stream().reduce(t2, binaryOperator);
    }

    public Stream<T> stream() {
        return this.stream;
    }
}

