/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.ArraySorter;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.time.FastDateParser;
import org.apache.commons.lang3.time.FastDateParser$PatternStrategy;
import org.apache.commons.lang3.time.FastDateParser$TimeZoneStrategy$TzInfo;
import org.apache.commons.lang3.time.FastTimeZone;

class FastDateParser$TimeZoneStrategy
extends FastDateParser$PatternStrategy {
    private static final String RFC_822_TIME_ZONE = "[+-]\\d{4}";
    private static final String GMT_OPTION = "GMT[+-]\\d{1,2}:\\d{2}";
    private static final int ID = 0;
    private final Locale locale;
    private final Map<String, FastDateParser$TimeZoneStrategy$TzInfo> tzNames = new TreeMap<String, FastDateParser$TimeZoneStrategy$TzInfo>(String.CASE_INSENSITIVE_ORDER);

    FastDateParser$TimeZoneStrategy(Locale locale) {
        super(null);
        Object object;
        Object object2;
        this.locale = LocaleUtils.toLocale(locale);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("((?iu)[+-]\\d{4}|GMT[+-]\\d{1,2}:\\d{2}");
        TreeSet<Object> treeSet = new TreeSet<Object>(FastDateParser.access$500());
        String[][] stringArray = DateFormatSymbols.getInstance(locale).getZoneStrings();
        String[][] stringArray2 = stringArray;
        stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String[] stringArray3 = stringArray2[i2];
            object2 = stringArray3[0];
            if (((String)object2).equalsIgnoreCase("GMT")) continue;
            object = TimeZone.getTimeZone((String)object2);
            Object object3 = object2 = new FastDateParser$TimeZoneStrategy$TzInfo((TimeZone)object, false);
            for (int i3 = 1; i3 < stringArray3.length; ++i3) {
                switch (i3) {
                    case 3: {
                        object3 = new FastDateParser$TimeZoneStrategy$TzInfo((TimeZone)object, true);
                        break;
                    }
                    case 5: {
                        object3 = object2;
                    }
                }
                String string2 = stringArray3[i3];
                if (string2 == null || !treeSet.add(string2)) continue;
                this.tzNames.put(string2, (FastDateParser$TimeZoneStrategy$TzInfo)object3);
            }
        }
        for (String[] stringArray3 : ArraySorter.sort(TimeZone.getAvailableIDs())) {
            if (stringArray3.equalsIgnoreCase("GMT") || !treeSet.add(object = ((TimeZone)(object2 = TimeZone.getTimeZone((String)stringArray3))).getDisplayName(locale))) continue;
            Object object4 = object2;
            this.tzNames.put((String)object, new FastDateParser$TimeZoneStrategy$TzInfo((TimeZone)object4, ((TimeZone)object4).observesDaylightTime()));
        }
        treeSet.forEach(string -> FastDateParser.access$600(stringBuilder.append('|'), string));
        stringBuilder.append(")");
        this.createPattern(stringBuilder);
    }

    @Override
    void setCalendar(FastDateParser object, Calendar calendar, String string) {
        object = FastTimeZone.getGmtTimeZone(string);
        if (object != null) {
            calendar.setTimeZone((TimeZone)object);
            return;
        }
        object = this.tzNames.get(string);
        if (object == null && (object = this.tzNames.get(string + '.')) == null) {
            object = string.toCharArray();
            throw new IllegalStateException(String.format("Can't find time zone '%s' (%d %s) in %s", string, ((Object)object).length, Arrays.toString((char[])object), new TreeSet<String>(this.tzNames.keySet())));
        }
        calendar.set(16, ((FastDateParser$TimeZoneStrategy$TzInfo)object).dstOffset);
        calendar.set(15, ((FastDateParser$TimeZoneStrategy$TzInfo)object).zone.getRawOffset());
    }

    @Override
    public String toString() {
        return "TimeZoneStrategy [locale=" + this.locale + ", tzNames=" + this.tzNames + ", pattern=" + this.pattern + "]";
    }
}

