/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.time.FastDatePrinter;
import org.apache.commons.lang3.time.FastDatePrinter$Rule;

final class FastDatePrinter$TimeZoneNameRule
implements FastDatePrinter$Rule {
    private final Locale locale;
    private final int style;
    private final String standard;
    private final String daylight;

    FastDatePrinter$TimeZoneNameRule(TimeZone timeZone, Locale locale, int n2) {
        this.locale = LocaleUtils.toLocale(locale);
        this.style = n2;
        this.standard = FastDatePrinter.getTimeZoneDisplay(timeZone, false, n2, locale);
        this.daylight = FastDatePrinter.getTimeZoneDisplay(timeZone, true, n2, locale);
    }

    @Override
    public final void appendTo(Appendable appendable, Calendar calendar) throws IOException {
        TimeZone timeZone = calendar.getTimeZone();
        boolean bl2 = calendar.get(16) != 0;
        appendable.append(FastDatePrinter.getTimeZoneDisplay(timeZone, bl2, this.style, this.locale));
    }

    @Override
    public final int estimateLength() {
        return Math.max(this.standard.length(), this.daylight.length());
    }
}

