/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.function.FailableRunnable;
import org.apache.commons.lang3.function.FailableSupplier;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch$SplitState;
import org.apache.commons.lang3.time.StopWatch$State;

public class StopWatch {
    private static final long NANO_2_MILLIS = 1000000L;
    private final String message;
    private StopWatch$State runningState = StopWatch$State.UNSTARTED;
    private StopWatch$SplitState splitState = StopWatch$SplitState.UNSPLIT;
    private long startTimeNanos;
    private Instant startInstant;
    private Instant stopInstant;
    private long stopTimeNanos;

    public static StopWatch create() {
        return new StopWatch();
    }

    public static StopWatch createStarted() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        return stopWatch;
    }

    public StopWatch() {
        this(null);
    }

    public StopWatch(String string) {
        this.message = string;
    }

    public String formatSplitTime() {
        return DurationFormatUtils.formatDurationHMS(this.getSplitDuration().toMillis());
    }

    public String formatTime() {
        return DurationFormatUtils.formatDurationHMS(this.getTime());
    }

    public <T> T get(Supplier<T> supplier) {
        this.startResume();
        try {
            supplier = supplier.get();
            return (T)supplier;
        }
        finally {
            this.suspend();
        }
    }

    public Duration getDuration() {
        return Duration.ofNanos(this.getNanoTime());
    }

    public String getMessage() {
        return this.message;
    }

    public long getNanoTime() {
        switch (this.runningState) {
            case STOPPED: 
            case SUSPENDED: {
                return this.stopTimeNanos - this.startTimeNanos;
            }
            case UNSTARTED: {
                return 0L;
            }
            case RUNNING: {
                return System.nanoTime() - this.startTimeNanos;
            }
        }
        throw new IllegalStateException("Illegal running state has occurred.");
    }

    public Duration getSplitDuration() {
        return Duration.ofNanos(this.getSplitNanoTime());
    }

    public long getSplitNanoTime() {
        if (this.splitState != StopWatch$SplitState.SPLIT) {
            throw new IllegalStateException("Stopwatch must be split to get the split time.");
        }
        return this.stopTimeNanos - this.startTimeNanos;
    }

    @Deprecated
    public long getSplitTime() {
        StopWatch stopWatch = this;
        return stopWatch.nanosToMillis(stopWatch.getSplitNanoTime());
    }

    public Instant getStartInstant() {
        if (this.runningState == StopWatch$State.UNSTARTED) {
            throw new IllegalStateException("Stopwatch has not been started");
        }
        return this.startInstant;
    }

    @Deprecated
    public long getStartTime() {
        return this.getStartInstant().toEpochMilli();
    }

    public Instant getStopInstant() {
        if (this.runningState == StopWatch$State.UNSTARTED) {
            throw new IllegalStateException("Stopwatch has not been started");
        }
        return this.stopInstant;
    }

    @Deprecated
    public long getStopTime() {
        return this.getStopInstant().toEpochMilli();
    }

    public <T, E extends Throwable> T getT(FailableSupplier<T, E> failableSupplier) throws Throwable {
        this.startResume();
        try {
            failableSupplier = failableSupplier.get();
            return (T)failableSupplier;
        }
        finally {
            this.suspend();
        }
    }

    public long getTime() {
        StopWatch stopWatch = this;
        return stopWatch.nanosToMillis(stopWatch.getNanoTime());
    }

    public long getTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.getNanoTime(), TimeUnit.NANOSECONDS);
    }

    public boolean isStarted() {
        return this.runningState.isStarted();
    }

    public boolean isStopped() {
        return this.runningState.isStopped();
    }

    public boolean isSuspended() {
        return this.runningState.isSuspended();
    }

    private long nanosToMillis(long l2) {
        return l2 / 1000000L;
    }

    public void reset() {
        this.runningState = StopWatch$State.UNSTARTED;
        this.splitState = StopWatch$SplitState.UNSPLIT;
    }

    public void resume() {
        if (this.runningState != StopWatch$State.SUSPENDED) {
            throw new IllegalStateException("Stopwatch must be suspended to resume.");
        }
        this.startTimeNanos += System.nanoTime() - this.stopTimeNanos;
        this.runningState = StopWatch$State.RUNNING;
    }

    public void run(Runnable runnable) {
        this.startResume();
        try {
            runnable.run();
            return;
        }
        finally {
            this.suspend();
        }
    }

    public <E extends Throwable> void runT(FailableRunnable<E> failableRunnable) throws Throwable {
        this.startResume();
        try {
            failableRunnable.run();
            return;
        }
        finally {
            this.suspend();
        }
    }

    public void split() {
        if (this.runningState != StopWatch$State.RUNNING) {
            throw new IllegalStateException("Stopwatch is not running.");
        }
        this.stopTimeNanos = System.nanoTime();
        this.splitState = StopWatch$SplitState.SPLIT;
    }

    public void start() {
        if (this.runningState == StopWatch$State.STOPPED) {
            throw new IllegalStateException("Stopwatch must be reset before being restarted.");
        }
        if (this.runningState != StopWatch$State.UNSTARTED) {
            throw new IllegalStateException("Stopwatch already started.");
        }
        this.startTimeNanos = System.nanoTime();
        this.startInstant = Instant.now();
        this.runningState = StopWatch$State.RUNNING;
    }

    private void startResume() {
        if (this.isStopped()) {
            this.start();
            return;
        }
        if (this.isSuspended()) {
            this.resume();
        }
    }

    public void stop() {
        if (this.runningState != StopWatch$State.RUNNING && this.runningState != StopWatch$State.SUSPENDED) {
            throw new IllegalStateException("Stopwatch is not running.");
        }
        if (this.runningState == StopWatch$State.RUNNING) {
            this.stopTimeNanos = System.nanoTime();
            this.stopInstant = Instant.now();
        }
        this.runningState = StopWatch$State.STOPPED;
    }

    public void suspend() {
        if (this.runningState != StopWatch$State.RUNNING) {
            throw new IllegalStateException("Stopwatch must be running to suspend.");
        }
        this.stopTimeNanos = System.nanoTime();
        this.stopInstant = Instant.now();
        this.runningState = StopWatch$State.SUSPENDED;
    }

    public String toSplitString() {
        String string = Objects.toString(this.message, "");
        String string2 = this.formatSplitTime();
        if (string.isEmpty()) {
            return string2;
        }
        return string + " " + string2;
    }

    public String toString() {
        String string = Objects.toString(this.message, "");
        String string2 = this.formatTime();
        if (string.isEmpty()) {
            return string2;
        }
        return string + " " + string2;
    }

    public void unsplit() {
        if (this.splitState != StopWatch$SplitState.SPLIT) {
            throw new IllegalStateException("Stopwatch has not been split.");
        }
        this.splitState = StopWatch$SplitState.UNSPLIT;
    }
}

