/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class ImmutablePair<L, R>
extends Pair<L, R> {
    public static final ImmutablePair<?, ?>[] EMPTY_ARRAY = new ImmutablePair[0];
    private static final ImmutablePair NULL = new ImmutablePair<Object, Object>(null, null);
    private static final long serialVersionUID = 4954918890077093841L;
    public final L left;
    public final R right;

    public static <L, R> ImmutablePair<L, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, R> Pair<L, R> left(L l2) {
        return ImmutablePair.of(l2, null);
    }

    public static <L, R> ImmutablePair<L, R> nullPair() {
        return NULL;
    }

    public static <L, R> ImmutablePair<L, R> of(L l2, R r2) {
        if (l2 != null || r2 != null) {
            return new ImmutablePair<L, R>(l2, r2);
        }
        return ImmutablePair.nullPair();
    }

    public static <L, R> ImmutablePair<L, R> of(Map.Entry<L, R> entry) {
        if (entry != null) {
            return new ImmutablePair<L, R>(entry.getKey(), entry.getValue());
        }
        return ImmutablePair.nullPair();
    }

    public static <L, R> ImmutablePair<L, R> ofNonNull(L l2, R r2) {
        return ImmutablePair.of(Objects.requireNonNull(l2, "left"), Objects.requireNonNull(r2, "right"));
    }

    public static <L, R> Pair<L, R> right(R r2) {
        return ImmutablePair.of(null, r2);
    }

    public ImmutablePair(L l2, R r2) {
        this.left = l2;
        this.right = r2;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    @Override
    public R setValue(R r2) {
        throw new UnsupportedOperationException();
    }
}

