/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.util;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;
import java.util.stream.IntStream;

public final class FluentBitSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final BitSet bitSet;

    public FluentBitSet() {
        this(new BitSet());
    }

    public FluentBitSet(BitSet bitSet) {
        this.bitSet = Objects.requireNonNull(bitSet, "set");
    }

    public FluentBitSet(int n2) {
        this(new BitSet(n2));
    }

    public final FluentBitSet and(BitSet bitSet) {
        this.bitSet.and(bitSet);
        return this;
    }

    public final FluentBitSet and(FluentBitSet fluentBitSet) {
        this.bitSet.and(fluentBitSet.bitSet);
        return this;
    }

    public final FluentBitSet andNot(BitSet bitSet) {
        this.bitSet.andNot(bitSet);
        return this;
    }

    public final FluentBitSet andNot(FluentBitSet fluentBitSet) {
        this.bitSet.andNot(fluentBitSet.bitSet);
        return this;
    }

    public final BitSet bitSet() {
        return this.bitSet;
    }

    public final int cardinality() {
        return this.bitSet.cardinality();
    }

    public final FluentBitSet clear() {
        this.bitSet.clear();
        return this;
    }

    public final FluentBitSet clear(int ... nArray) {
        for (int n2 : nArray) {
            this.bitSet.clear(n2);
        }
        return this;
    }

    public final FluentBitSet clear(int n2) {
        this.bitSet.clear(n2);
        return this;
    }

    public final FluentBitSet clear(int n2, int n3) {
        this.bitSet.clear(n2, n3);
        return this;
    }

    public final Object clone() {
        return new FluentBitSet((BitSet)this.bitSet.clone());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FluentBitSet)) {
            return false;
        }
        object = (FluentBitSet)object;
        return Objects.equals(this.bitSet, ((FluentBitSet)object).bitSet);
    }

    public final FluentBitSet flip(int n2) {
        this.bitSet.flip(n2);
        return this;
    }

    public final FluentBitSet flip(int n2, int n3) {
        this.bitSet.flip(n2, n3);
        return this;
    }

    public final boolean get(int n2) {
        return this.bitSet.get(n2);
    }

    public final FluentBitSet get(int n2, int n3) {
        return new FluentBitSet(this.bitSet.get(n2, n3));
    }

    public final int hashCode() {
        return this.bitSet.hashCode();
    }

    public final boolean intersects(BitSet bitSet) {
        return this.bitSet.intersects(bitSet);
    }

    public final boolean intersects(FluentBitSet fluentBitSet) {
        return this.bitSet.intersects(fluentBitSet.bitSet);
    }

    public final boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    public final int length() {
        return this.bitSet.length();
    }

    public final int nextClearBit(int n2) {
        return this.bitSet.nextClearBit(n2);
    }

    public final int nextSetBit(int n2) {
        return this.bitSet.nextSetBit(n2);
    }

    public final FluentBitSet or(BitSet bitSet) {
        this.bitSet.or(bitSet);
        return this;
    }

    public final FluentBitSet or(FluentBitSet ... fluentBitSetArray) {
        for (FluentBitSet fluentBitSet : fluentBitSetArray) {
            this.bitSet.or(fluentBitSet.bitSet);
        }
        return this;
    }

    public final FluentBitSet or(FluentBitSet fluentBitSet) {
        this.bitSet.or(fluentBitSet.bitSet);
        return this;
    }

    public final int previousClearBit(int n2) {
        return this.bitSet.previousClearBit(n2);
    }

    public final int previousSetBit(int n2) {
        return this.bitSet.previousSetBit(n2);
    }

    public final FluentBitSet set(int ... nArray) {
        for (int n2 : nArray) {
            this.bitSet.set(n2);
        }
        return this;
    }

    public final FluentBitSet set(int n2) {
        this.bitSet.set(n2);
        return this;
    }

    public final FluentBitSet set(int n2, boolean bl2) {
        this.bitSet.set(n2, bl2);
        return this;
    }

    public final FluentBitSet set(int n2, int n3) {
        this.bitSet.set(n2, n3);
        return this;
    }

    public final FluentBitSet set(int n2, int n3, boolean bl2) {
        this.bitSet.set(n2, n3, bl2);
        return this;
    }

    public final FluentBitSet setInclusive(int n2, int n3) {
        this.bitSet.set(n2, n3 + 1);
        return this;
    }

    public final int size() {
        return this.bitSet.size();
    }

    public final IntStream stream() {
        return this.bitSet.stream();
    }

    public final byte[] toByteArray() {
        return this.bitSet.toByteArray();
    }

    public final long[] toLongArray() {
        return this.bitSet.toLongArray();
    }

    public final String toString() {
        return this.bitSet.toString();
    }

    public final FluentBitSet xor(BitSet bitSet) {
        this.bitSet.xor(bitSet);
        return this;
    }

    public final FluentBitSet xor(FluentBitSet fluentBitSet) {
        this.bitSet.xor(fluentBitSet.bitSet);
        return this;
    }
}

