/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.util.Args;

public abstract class AbstractClientContextBuilder<T extends HttpClientContext> {
    private final SchemePortResolver schemePortResolver;
    private Lookup<CookieSpecFactory> cookieSpecRegistry;
    private Lookup<AuthSchemeFactory> authSchemeRegistry;
    private CookieStore cookieStore;
    private CredentialsProvider credentialsProvider;
    private AuthCache authCache;
    private Map<HttpHost, AuthScheme> authSchemeMap;

    protected AbstractClientContextBuilder(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public AbstractClientContextBuilder<T> useCookieSpecRegistry(Lookup<CookieSpecFactory> lookup) {
        this.cookieSpecRegistry = lookup;
        return this;
    }

    public AbstractClientContextBuilder<T> useAuthSchemeRegistry(Lookup<AuthSchemeFactory> lookup) {
        this.authSchemeRegistry = lookup;
        return this;
    }

    public AbstractClientContextBuilder<T> useCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public AbstractClientContextBuilder<T> useCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public AbstractClientContextBuilder<T> useAuthCache(AuthCache authCache) {
        this.authCache = authCache;
        return this;
    }

    public AbstractClientContextBuilder<T> preemptiveAuth(HttpHost httpHost, AuthScheme authScheme) {
        Args.notNull(httpHost, "HTTP host");
        if (this.authSchemeMap == null) {
            this.authSchemeMap = new HashMap<HttpHost, AuthScheme>();
        }
        this.authSchemeMap.put(RoutingSupport.normalize(httpHost, this.schemePortResolver), authScheme);
        return this;
    }

    public AbstractClientContextBuilder<T> preemptiveBasicAuth(HttpHost httpHost, UsernamePasswordCredentials usernamePasswordCredentials) {
        Args.notNull(httpHost, "HTTP host");
        BasicScheme basicScheme = new BasicScheme();
        basicScheme.initPreemptive(usernamePasswordCredentials);
        this.preemptiveAuth(httpHost, basicScheme);
        return this;
    }

    protected abstract T createContext();

    public T build() {
        T t2 = this.createContext();
        ((HttpClientContext)t2).setCookieSpecRegistry(this.cookieSpecRegistry);
        ((HttpClientContext)t2).setAuthSchemeRegistry(this.authSchemeRegistry);
        ((HttpClientContext)t2).setCookieStore(this.cookieStore);
        ((HttpClientContext)t2).setCredentialsProvider(this.credentialsProvider);
        ((HttpClientContext)t2).setAuthCache(this.authCache);
        if (this.authSchemeMap != null) {
            for (Map.Entry<HttpHost, AuthScheme> entry : this.authSchemeMap.entrySet()) {
                ((HttpClientContext)t2).resetAuthExchange(entry.getKey(), entry.getValue());
            }
        }
        return t2;
    }
}

