/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.net.NamedEndpoint;

@Internal
public final class ConnectExceptionSupport {
    public static ConnectTimeoutException createConnectTimeoutException(IOException object, NamedEndpoint namedEndpoint, InetAddress ... inetAddressArray) {
        object = "Connect to " + (namedEndpoint != null ? namedEndpoint : "remote endpoint") + (inetAddressArray != null && inetAddressArray.length > 0 ? " " + Arrays.asList(inetAddressArray) : "") + (object != null && ((Throwable)object).getMessage() != null ? " failed: " + ((Throwable)object).getMessage() : " timed out");
        return new ConnectTimeoutException((String)object, namedEndpoint);
    }

    public static HttpHostConnectException createHttpHostConnectException(IOException object, NamedEndpoint namedEndpoint, InetAddress ... inetAddressArray) {
        object = "Connect to " + (namedEndpoint != null ? namedEndpoint : "remote endpoint") + (inetAddressArray != null && inetAddressArray.length > 0 ? " " + Arrays.asList(inetAddressArray) : "") + (object != null && ((Throwable)object).getMessage() != null ? " failed: " + ((Throwable)object).getMessage() : " refused");
        return new HttpHostConnectException((String)object, namedEndpoint);
    }

    public static IOException enhance(IOException iOException, NamedEndpoint object, InetAddress ... inetAddressArray) {
        if (iOException instanceof SocketTimeoutException) {
            object = ConnectExceptionSupport.createConnectTimeoutException(iOException, (NamedEndpoint)object, inetAddressArray);
            ((Throwable)object).setStackTrace(iOException.getStackTrace());
            return object;
        }
        if (iOException instanceof ConnectException) {
            if ("Connection timed out".equals(iOException.getMessage())) {
                object = ConnectExceptionSupport.createConnectTimeoutException(iOException, (NamedEndpoint)object, inetAddressArray);
                ((Throwable)object).initCause(iOException);
                return object;
            }
            object = ConnectExceptionSupport.createHttpHostConnectException(iOException, (NamedEndpoint)object, inetAddressArray);
            ((Throwable)object).setStackTrace(iOException.getStackTrace());
            return object;
        }
        return iOException;
    }
}

