/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.RouteInfo$LayerType;
import org.apache.hc.client5.http.RouteInfo$TunnelType;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.LangUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class HttpRoute
implements Cloneable,
RouteInfo {
    private final HttpHost targetHost;
    private final NamedEndpoint targetName;
    private final InetAddress localAddress;
    private final List<HttpHost> proxyChain;
    private final RouteInfo$TunnelType tunnelled;
    private final RouteInfo$LayerType layered;
    private final boolean secure;

    HttpRoute(HttpHost httpHost, NamedEndpoint namedEndpoint, InetAddress inetAddress, List<HttpHost> list, boolean bl2, RouteInfo$TunnelType routeInfo$TunnelType, RouteInfo$LayerType routeInfo$LayerType) {
        Args.notNull(httpHost, "Target host");
        Args.notNegative(httpHost.getPort(), "Target port");
        this.targetName = namedEndpoint;
        this.targetHost = httpHost;
        this.localAddress = inetAddress;
        this.proxyChain = list != null && !list.isEmpty() ? new ArrayList<HttpHost>(list) : null;
        if (routeInfo$TunnelType == RouteInfo$TunnelType.TUNNELLED) {
            Args.check(this.proxyChain != null, "Proxy required if tunnelled");
        }
        this.secure = bl2;
        this.tunnelled = routeInfo$TunnelType != null ? routeInfo$TunnelType : RouteInfo$TunnelType.PLAIN;
        this.layered = routeInfo$LayerType != null ? routeInfo$LayerType : RouteInfo$LayerType.PLAIN;
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost[] httpHostArray, boolean bl2, RouteInfo$TunnelType routeInfo$TunnelType, RouteInfo$LayerType routeInfo$LayerType) {
        this(httpHost, null, inetAddress, httpHostArray != null ? Arrays.asList(httpHostArray) : null, bl2, routeInfo$TunnelType, routeInfo$LayerType);
    }

    public HttpRoute(HttpHost httpHost, NamedEndpoint namedEndpoint, InetAddress inetAddress, HttpHost[] httpHostArray, boolean bl2, RouteInfo$TunnelType routeInfo$TunnelType, RouteInfo$LayerType routeInfo$LayerType) {
        this(httpHost, namedEndpoint, inetAddress, httpHostArray != null ? Arrays.asList(httpHostArray) : null, bl2, routeInfo$TunnelType, routeInfo$LayerType);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost httpHost2, boolean bl2, RouteInfo$TunnelType routeInfo$TunnelType, RouteInfo$LayerType routeInfo$LayerType) {
        this(httpHost, null, inetAddress, httpHost2 != null ? Collections.singletonList(httpHost2) : null, bl2, routeInfo$TunnelType, routeInfo$LayerType);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, boolean bl2) {
        this(httpHost, null, inetAddress, Collections.emptyList(), bl2, RouteInfo$TunnelType.PLAIN, RouteInfo$LayerType.PLAIN);
    }

    public HttpRoute(HttpHost httpHost, NamedEndpoint namedEndpoint, InetAddress inetAddress, boolean bl2) {
        this(httpHost, namedEndpoint, inetAddress, Collections.emptyList(), bl2, RouteInfo$TunnelType.PLAIN, RouteInfo$LayerType.PLAIN);
    }

    public HttpRoute(HttpHost httpHost) {
        this(httpHost, null, null, Collections.emptyList(), false, RouteInfo$TunnelType.PLAIN, RouteInfo$LayerType.PLAIN);
    }

    public HttpRoute(HttpHost httpHost, NamedEndpoint namedEndpoint, InetAddress inetAddress, HttpHost httpHost2, boolean bl2) {
        boolean bl3 = bl2;
        this(httpHost, namedEndpoint, inetAddress, Collections.singletonList(Args.notNull(httpHost2, "Proxy host")), bl3, bl3 ? RouteInfo$TunnelType.TUNNELLED : RouteInfo$TunnelType.PLAIN, bl2 ? RouteInfo$LayerType.LAYERED : RouteInfo$LayerType.PLAIN);
    }

    public HttpRoute(HttpHost httpHost, InetAddress inetAddress, HttpHost httpHost2, boolean bl2) {
        boolean bl3 = bl2;
        this(httpHost, null, inetAddress, Collections.singletonList(Args.notNull(httpHost2, "Proxy host")), bl3, bl3 ? RouteInfo$TunnelType.TUNNELLED : RouteInfo$TunnelType.PLAIN, bl2 ? RouteInfo$LayerType.LAYERED : RouteInfo$LayerType.PLAIN);
    }

    public HttpRoute(HttpHost httpHost, HttpHost httpHost2) {
        this(httpHost, null, httpHost2, false);
    }

    @Override
    public final HttpHost getTargetHost() {
        return this.targetHost;
    }

    @Override
    public final NamedEndpoint getTargetName() {
        return this.targetName;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public final InetSocketAddress getLocalSocketAddress() {
        if (this.localAddress != null) {
            return new InetSocketAddress(this.localAddress, 0);
        }
        return null;
    }

    @Override
    public final int getHopCount() {
        if (this.proxyChain != null) {
            return this.proxyChain.size() + 1;
        }
        return 1;
    }

    @Override
    public final HttpHost getHopTarget(int n2) {
        Args.notNegative(n2, "Hop index");
        int n3 = this.getHopCount();
        Args.check(n2 < n3, "Hop index exceeds tracked route length");
        if (n2 < n3 - 1) {
            return this.proxyChain.get(n2);
        }
        return this.targetHost;
    }

    @Override
    public final HttpHost getProxyHost() {
        if (this.proxyChain != null && !this.proxyChain.isEmpty()) {
            return this.proxyChain.get(0);
        }
        return null;
    }

    @Override
    public final RouteInfo$TunnelType getTunnelType() {
        return this.tunnelled;
    }

    @Override
    public final boolean isTunnelled() {
        return this.tunnelled == RouteInfo$TunnelType.TUNNELLED;
    }

    @Override
    public final RouteInfo$LayerType getLayerType() {
        return this.layered;
    }

    @Override
    public final boolean isLayered() {
        return this.layered == RouteInfo$LayerType.LAYERED;
    }

    @Override
    public final boolean isSecure() {
        return this.secure;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HttpRoute) {
            object = (HttpRoute)object;
            return this.secure == ((HttpRoute)object).secure && this.tunnelled == ((HttpRoute)object).tunnelled && this.layered == ((HttpRoute)object).layered && Objects.equals(this.targetHost, ((HttpRoute)object).targetHost) && Objects.equals(this.targetName, ((HttpRoute)object).targetName) && Objects.equals(this.localAddress, ((HttpRoute)object).localAddress) && Objects.equals(this.proxyChain, ((HttpRoute)object).proxyChain);
        }
        return false;
    }

    public final int hashCode() {
        int n2 = LangUtils.hashCode(17, this.targetHost);
        n2 = LangUtils.hashCode(n2, this.targetName);
        n2 = LangUtils.hashCode(n2, this.localAddress);
        if (this.proxyChain != null) {
            for (HttpHost httpHost : this.proxyChain) {
                n2 = LangUtils.hashCode(n2, httpHost);
            }
        }
        n2 = LangUtils.hashCode(n2, this.secure);
        n2 = LangUtils.hashCode(n2, (Object)this.tunnelled);
        n2 = LangUtils.hashCode(n2, (Object)this.layered);
        return n2;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(50 + this.getHopCount() * 30);
        if (this.localAddress != null) {
            stringBuilder.append(this.localAddress);
            stringBuilder.append("->");
        }
        stringBuilder.append('{');
        if (this.tunnelled == RouteInfo$TunnelType.TUNNELLED) {
            stringBuilder.append('t');
        }
        if (this.layered == RouteInfo$LayerType.LAYERED) {
            stringBuilder.append('l');
        }
        if (this.secure) {
            stringBuilder.append('s');
        }
        stringBuilder.append("}->");
        if (this.proxyChain != null) {
            for (HttpHost httpHost : this.proxyChain) {
                stringBuilder.append(httpHost);
                stringBuilder.append("->");
            }
        }
        if (this.targetName != null) {
            stringBuilder.append(this.targetName);
            stringBuilder.append("/");
        }
        stringBuilder.append("[");
        stringBuilder.append(this.targetHost);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

