/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http;

import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.core5.util.TextUtils;

public class SystemDefaultDnsResolver
implements DnsResolver {
    public static final SystemDefaultDnsResolver INSTANCE = new SystemDefaultDnsResolver();

    @Override
    public InetAddress[] resolve(String string) throws UnknownHostException {
        try {
            String string2;
            if (TextUtils.isAllASCII(string)) {
                string2 = string;
            } else {
                try {
                    string2 = IDN.toASCII(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string2 = string;
                }
            }
            return InetAddress.getAllByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            int n2;
            String string3 = null;
            if (string.charAt(0) == '[' && (n2 = string.lastIndexOf(37)) != -1) {
                string3 = string.substring(0, n2) + "]";
            }
            if (string3 != null) {
                return InetAddress.getAllByName(string3);
            }
            throw unknownHostException;
        }
    }

    @Override
    public String resolveCanonicalHostname(String string) throws UnknownHostException {
        if (string == null) {
            return null;
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        String string2 = inetAddress.getCanonicalHostName();
        if (inetAddress.getHostAddress().contentEquals(string2)) {
            return string;
        }
        return string2;
    }
}

