/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.AbstractBinDataConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;

public abstract class AbstractBinResponseConsumer<T>
extends AbstractBinDataConsumer
implements AsyncResponseConsumer<T> {
    private volatile FutureCallback<T> resultCallback;

    protected abstract void start(HttpResponse var1, ContentType var2) throws HttpException, IOException;

    protected abstract T buildResult();

    @Override
    public void informationResponse(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
    }

    @Override
    public final void consumeResponse(HttpResponse httpResponse, EntityDetails object, HttpContext httpContext, FutureCallback<T> futureCallback) throws HttpException, IOException {
        this.resultCallback = futureCallback;
        if (object != null) {
            try {
                object = ContentType.parse(object.getContentType());
                this.start(httpResponse, (ContentType)(object != null ? object : ContentType.DEFAULT_BINARY));
                return;
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
            }
        }
        this.start(httpResponse, null);
        this.completed();
    }

    @Override
    protected final void completed() {
        this.resultCallback.completed(this.buildResult());
    }

    @Override
    public void failed(Exception exception) {
    }
}

