/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.entity.AbstractCharDataConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;

public abstract class AbstractCharPushConsumer
extends AbstractCharDataConsumer
implements AsyncPushConsumer {
    private final Charset defaultCharset;

    public AbstractCharPushConsumer() {
        this.defaultCharset = StandardCharsets.UTF_8;
    }

    protected AbstractCharPushConsumer(int n2, CharCodingConfig charCodingConfig) {
        super(n2, charCodingConfig);
        this.defaultCharset = charCodingConfig != null && charCodingConfig.getCharset() != null ? charCodingConfig.getCharset() : StandardCharsets.UTF_8;
    }

    protected abstract void start(HttpRequest var1, HttpResponse var2, ContentType var3) throws HttpException, IOException;

    @Override
    public final void consumePromise(HttpRequest httpRequest, HttpResponse httpResponse, EntityDetails object, HttpContext object2) throws HttpException, IOException {
        if (object != null) {
            try {
                object = ContentType.parse(object.getContentType());
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
            }
            object2 = object != null ? ((ContentType)object).getCharset() : null;
            if (object2 == null) {
                object2 = this.defaultCharset;
            }
            this.setCharset((Charset)object2);
            this.start(httpRequest, httpResponse, (ContentType)(object != null ? object : ContentType.DEFAULT_TEXT));
            return;
        }
        this.start(httpRequest, httpResponse, null);
        this.completed();
    }

    @Override
    public void failed(Exception exception) {
    }
}

