/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.AbstractCharDataConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;

public abstract class AbstractCharResponseConsumer<T>
extends AbstractCharDataConsumer
implements AsyncResponseConsumer<T> {
    private volatile FutureCallback<T> resultCallback;
    private final Charset defaultCharset;

    public AbstractCharResponseConsumer() {
        this.defaultCharset = StandardCharsets.UTF_8;
    }

    protected AbstractCharResponseConsumer(int n2, CharCodingConfig charCodingConfig) {
        super(n2, charCodingConfig);
        this.defaultCharset = charCodingConfig != null && charCodingConfig.getCharset() != null ? charCodingConfig.getCharset() : StandardCharsets.UTF_8;
    }

    protected abstract void start(HttpResponse var1, ContentType var2) throws HttpException, IOException;

    protected abstract T buildResult() throws IOException;

    @Override
    public void informationResponse(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
    }

    @Override
    public final void consumeResponse(HttpResponse httpResponse, EntityDetails object, HttpContext object2, FutureCallback<T> futureCallback) throws HttpException, IOException {
        this.resultCallback = futureCallback;
        if (object != null) {
            try {
                object = ContentType.parse(object.getContentType());
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
            }
            object2 = object != null ? ((ContentType)object).getCharset() : null;
            if (object2 == null) {
                object2 = this.defaultCharset;
            }
            this.setCharset((Charset)object2);
            this.start(httpResponse, (ContentType)(object != null ? object : ContentType.DEFAULT_TEXT));
            return;
        }
        this.start(httpResponse, null);
        this.completed();
    }

    @Override
    protected final void completed() throws IOException {
        this.resultCallback.completed(this.buildResult());
    }

    @Override
    public void failed(Exception exception) {
    }
}

