/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import org.apache.hc.core5.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreCompleteExceptionFutureCallback<T>
implements FutureCallback<T> {
    private final FutureCallback<T> callback;
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreCompleteExceptionFutureCallback.class);

    public IgnoreCompleteExceptionFutureCallback(FutureCallback<T> futureCallback) {
        this.callback = futureCallback;
    }

    @Override
    public void completed(T t2) {
        if (this.callback != null) {
            try {
                this.callback.completed(t2);
                return;
            }
            catch (Exception exception) {
                LOG.error(exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void failed(Exception exception) {
        if (this.callback != null) {
            this.callback.failed(exception);
        }
    }

    @Override
    public void cancelled() {
        if (this.callback != null) {
            this.callback.cancelled();
        }
    }
}

