/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.util.Args;

public final class SimpleHttpResponse
extends BasicHttpResponse {
    private static final long serialVersionUID = 1L;
    private SimpleBody body;

    public SimpleHttpResponse(int n2) {
        super(n2);
    }

    public SimpleHttpResponse(int n2, String string) {
        super(n2, string);
    }

    public static SimpleHttpResponse copy(HttpResponse object) {
        Args.notNull(object, "HTTP response");
        SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(object.getCode());
        simpleHttpResponse.setVersion(object.getVersion());
        object = object.headerIterator();
        while (object.hasNext()) {
            simpleHttpResponse.addHeader((Header)object.next());
        }
        return simpleHttpResponse;
    }

    public static SimpleHttpResponse create(int n2) {
        return new SimpleHttpResponse(n2);
    }

    public static SimpleHttpResponse create(int n2, String string, ContentType contentType) {
        SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(n2);
        if (string != null) {
            simpleHttpResponse.setBody(string, contentType);
        }
        return simpleHttpResponse;
    }

    public static SimpleHttpResponse create(int n2, String string) {
        return SimpleHttpResponse.create(n2, string, ContentType.TEXT_PLAIN);
    }

    public static SimpleHttpResponse create(int n2, byte[] byArray, ContentType contentType) {
        SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(n2);
        if (byArray != null) {
            simpleHttpResponse.setBody(byArray, contentType);
        }
        return simpleHttpResponse;
    }

    public static SimpleHttpResponse create(int n2, byte[] byArray) {
        return SimpleHttpResponse.create(n2, byArray, ContentType.TEXT_PLAIN);
    }

    public final void setBody(SimpleBody simpleBody) {
        this.body = simpleBody;
    }

    public final void setBody(byte[] byArray, ContentType contentType) {
        this.body = SimpleBody.create(byArray, contentType);
    }

    public final void setBody(String string, ContentType contentType) {
        this.body = SimpleBody.create(string, contentType);
    }

    public final SimpleBody getBody() {
        return this.body;
    }

    public final ContentType getContentType() {
        if (this.body != null) {
            return this.body.getContentType();
        }
        return null;
    }

    public final String getBodyText() {
        if (this.body != null) {
            return this.body.getBodyText();
        }
        return null;
    }

    public final byte[] getBodyBytes() {
        if (this.body != null) {
            return this.body.getBodyBytes();
        }
        return null;
    }
}

