/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.util.Arrays;
import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.support.AbstractResponseBuilder;
import org.apache.hc.core5.util.Args;

public class SimpleResponseBuilder
extends AbstractResponseBuilder<SimpleHttpResponse> {
    private SimpleBody body;

    SimpleResponseBuilder(int n2) {
        super(n2);
    }

    public static SimpleResponseBuilder create(int n2) {
        Args.checkRange(n2, 100, 599, "HTTP status code");
        return new SimpleResponseBuilder(n2);
    }

    public static SimpleResponseBuilder copy(SimpleHttpResponse simpleHttpResponse) {
        Args.notNull(simpleHttpResponse, "HTTP response");
        SimpleResponseBuilder simpleResponseBuilder = new SimpleResponseBuilder(simpleHttpResponse.getCode());
        simpleResponseBuilder.digest(simpleHttpResponse);
        return simpleResponseBuilder;
    }

    protected void digest(SimpleHttpResponse simpleHttpResponse) {
        super.digest(simpleHttpResponse);
        this.setBody(simpleHttpResponse.getBody());
    }

    @Override
    public SimpleResponseBuilder setVersion(ProtocolVersion protocolVersion) {
        super.setVersion(protocolVersion);
        return this;
    }

    @Override
    public SimpleResponseBuilder setHeaders(Header ... headerArray) {
        super.setHeaders(headerArray);
        return this;
    }

    @Override
    public SimpleResponseBuilder addHeader(Header header) {
        super.addHeader(header);
        return this;
    }

    @Override
    public SimpleResponseBuilder addHeader(String string, String string2) {
        super.addHeader(string, string2);
        return this;
    }

    @Override
    public SimpleResponseBuilder removeHeader(Header header) {
        super.removeHeader(header);
        return this;
    }

    @Override
    public SimpleResponseBuilder removeHeaders(String string) {
        super.removeHeaders(string);
        return this;
    }

    @Override
    public SimpleResponseBuilder setHeader(Header header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public SimpleResponseBuilder setHeader(String string, String string2) {
        super.setHeader(string, string2);
        return this;
    }

    public SimpleBody getBody() {
        return this.body;
    }

    public SimpleResponseBuilder setBody(SimpleBody simpleBody) {
        this.body = simpleBody;
        return this;
    }

    public SimpleResponseBuilder setBody(String string, ContentType contentType) {
        this.body = SimpleBody.create(string, contentType);
        return this;
    }

    public SimpleResponseBuilder setBody(byte[] byArray, ContentType contentType) {
        this.body = SimpleBody.create(byArray, contentType);
        return this;
    }

    @Override
    public SimpleHttpResponse build() {
        SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(this.getStatus());
        simpleHttpResponse.setVersion(this.getVersion());
        simpleHttpResponse.setHeaders(this.getHeaders());
        simpleHttpResponse.setBody(this.body);
        return simpleHttpResponse;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SimpleResponseBuilder [status=");
        stringBuilder.append(this.getStatus());
        stringBuilder.append(", headerGroup=");
        stringBuilder.append(Arrays.toString(this.getHeaders()));
        stringBuilder.append(", body=");
        stringBuilder.append(this.body);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

