/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import java.util.Queue;
import org.apache.hc.client5.http.auth.AuthExchange$State;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.core5.util.Args;

public class AuthExchange {
    private AuthExchange$State state = AuthExchange$State.UNCHALLENGED;
    private AuthScheme authScheme;
    private Queue<AuthScheme> authOptions;
    private String pathPrefix;

    public void reset() {
        this.state = AuthExchange$State.UNCHALLENGED;
        this.authOptions = null;
        this.authScheme = null;
        this.pathPrefix = null;
    }

    public AuthExchange$State getState() {
        return this.state;
    }

    public void setState(AuthExchange$State authExchange$State) {
        this.state = authExchange$State != null ? authExchange$State : AuthExchange$State.UNCHALLENGED;
    }

    public AuthScheme getAuthScheme() {
        return this.authScheme;
    }

    public boolean isConnectionBased() {
        return this.authScheme != null && this.authScheme.isConnectionBased();
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String string) {
        this.pathPrefix = string;
    }

    public void select(AuthScheme authScheme) {
        Args.notNull(authScheme, "Auth scheme");
        this.authScheme = authScheme;
        this.authOptions = null;
    }

    public Queue<AuthScheme> getAuthOptions() {
        return this.authOptions;
    }

    public void setOptions(Queue<AuthScheme> queue) {
        Args.notEmpty(queue, "Queue of auth options");
        this.authOptions = queue;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append((Object)this.state);
        if (this.authScheme != null) {
            stringBuilder.append(" ").append(this.authScheme);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

