/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.classic.methods;

import java.net.URI;
import java.util.concurrent.atomic.AtomicMarkableReference;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;

public class HttpUriRequestBase
extends BasicClassicHttpRequest
implements HttpUriRequest,
CancellableDependency {
    private static final long serialVersionUID = 1L;
    private final AtomicMarkableReference<Cancellable> cancellableRef = new AtomicMarkableReference<Object>(null, false);
    private RequestConfig requestConfig;

    public HttpUriRequestBase(String string, URI uRI) {
        super(string, uRI);
    }

    @Override
    public boolean cancel() {
        while (!this.cancellableRef.isMarked()) {
            Cancellable cancellable;
            Cancellable cancellable2 = cancellable = this.cancellableRef.getReference();
            if (!this.cancellableRef.compareAndSet(cancellable2, cancellable2, false, true)) continue;
            if (cancellable != null) {
                cancellable.cancel();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancellableRef.isMarked();
    }

    @Override
    public void setDependency(Cancellable cancellable) {
        Cancellable cancellable2 = this.cancellableRef.getReference();
        if (!this.cancellableRef.compareAndSet(cancellable2, cancellable, false, false)) {
            cancellable.cancel();
        }
    }

    public void reset() {
        boolean bl2;
        Cancellable cancellable;
        do {
            bl2 = this.cancellableRef.isMarked();
            cancellable = this.cancellableRef.getReference();
            if (cancellable == null) continue;
            cancellable.cancel();
        } while (!this.cancellableRef.compareAndSet(cancellable, null, bl2, false));
    }

    @Override
    public void abort() throws UnsupportedOperationException {
        this.cancel();
    }

    @Override
    public boolean isAborted() {
        return this.isCancelled();
    }

    public void setConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    @Override
    public RequestConfig getConfig() {
        return this.requestConfig;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getMethod()).append(" ").append(this.getRequestUri());
        return stringBuilder.toString();
    }
}

