/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.config;

import org.apache.hc.client5.http.config.ConnectionConfig$Builder;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ConnectionConfig
implements Cloneable {
    private static final Timeout DEFAULT_CONNECT_TIMEOUT = Timeout.ofMinutes(3L);
    public static final ConnectionConfig DEFAULT = new ConnectionConfig$Builder().build();
    private final Timeout connectTimeout;
    private final Timeout socketTimeout;
    private final TimeValue validateAfterInactivity;
    private final TimeValue timeToLive;

    protected ConnectionConfig() {
        this(DEFAULT_CONNECT_TIMEOUT, null, null, null);
    }

    ConnectionConfig(Timeout timeout, Timeout timeout2, TimeValue timeValue, TimeValue timeValue2) {
        this.connectTimeout = timeout;
        this.socketTimeout = timeout2;
        this.validateAfterInactivity = timeValue;
        this.timeToLive = timeValue2;
    }

    public Timeout getSocketTimeout() {
        return this.socketTimeout;
    }

    public Timeout getConnectTimeout() {
        return this.connectTimeout;
    }

    public TimeValue getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public TimeValue getTimeToLive() {
        return this.timeToLive;
    }

    protected ConnectionConfig clone() throws CloneNotSupportedException {
        return (ConnectionConfig)super.clone();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append("connectTimeout=").append(this.connectTimeout);
        stringBuilder.append(", socketTimeout=").append(this.socketTimeout);
        stringBuilder.append(", validateAfterInactivity=").append(this.validateAfterInactivity);
        stringBuilder.append(", timeToLive=").append(this.timeToLive);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static ConnectionConfig$Builder custom() {
        return new ConnectionConfig$Builder();
    }

    public static ConnectionConfig$Builder copy(ConnectionConfig connectionConfig) {
        return new ConnectionConfig$Builder().setConnectTimeout(connectionConfig.getConnectTimeout()).setSocketTimeout(connectionConfig.getSocketTimeout()).setValidateAfterInactivity(connectionConfig.getValidateAfterInactivity()).setTimeToLive(connectionConfig.getTimeToLive());
    }

    static /* synthetic */ Timeout access$000() {
        return DEFAULT_CONNECT_TIMEOUT;
    }
}

