/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.config;

import java.util.Collection;
import org.apache.hc.client5.http.config.RequestConfig$Builder;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConfig
implements Cloneable {
    private static final Timeout DEFAULT_CONNECTION_REQUEST_TIMEOUT = Timeout.ofMinutes(3L);
    private static final TimeValue DEFAULT_CONN_KEEP_ALIVE = TimeValue.ofMinutes(3L);
    public static final RequestConfig DEFAULT = new RequestConfig$Builder().build();
    private final boolean expectContinueEnabled;
    private final HttpHost proxy;
    private final String cookieSpec;
    private final boolean redirectsEnabled;
    private final boolean circularRedirectsAllowed;
    private final int maxRedirects;
    private final boolean authenticationEnabled;
    private final Collection<String> targetPreferredAuthSchemes;
    private final Collection<String> proxyPreferredAuthSchemes;
    private final Timeout connectionRequestTimeout;
    private final Timeout connectTimeout;
    private final Timeout responseTimeout;
    private final TimeValue connectionKeepAlive;
    private final boolean contentCompressionEnabled;
    private final boolean hardCancellationEnabled;
    private final boolean protocolUpgradeEnabled;

    protected RequestConfig() {
        this(false, null, null, false, false, 0, false, null, null, DEFAULT_CONNECTION_REQUEST_TIMEOUT, null, null, DEFAULT_CONN_KEEP_ALIVE, false, false, false);
    }

    RequestConfig(boolean bl2, HttpHost httpHost, String string, boolean bl3, boolean bl4, int n2, boolean bl5, Collection<String> collection, Collection<String> collection2, Timeout timeout, Timeout timeout2, Timeout timeout3, TimeValue timeValue, boolean bl6, boolean bl7, boolean bl8) {
        this.expectContinueEnabled = bl2;
        this.proxy = httpHost;
        this.cookieSpec = string;
        this.redirectsEnabled = bl3;
        this.circularRedirectsAllowed = bl4;
        this.maxRedirects = n2;
        this.authenticationEnabled = bl5;
        this.targetPreferredAuthSchemes = collection;
        this.proxyPreferredAuthSchemes = collection2;
        this.connectionRequestTimeout = timeout;
        this.connectTimeout = timeout2;
        this.responseTimeout = timeout3;
        this.connectionKeepAlive = timeValue;
        this.contentCompressionEnabled = bl6;
        this.hardCancellationEnabled = bl7;
        this.protocolUpgradeEnabled = bl8;
    }

    public boolean isExpectContinueEnabled() {
        return this.expectContinueEnabled;
    }

    @Deprecated
    public HttpHost getProxy() {
        return this.proxy;
    }

    public String getCookieSpec() {
        return this.cookieSpec;
    }

    public boolean isRedirectsEnabled() {
        return this.redirectsEnabled;
    }

    public boolean isCircularRedirectsAllowed() {
        return this.circularRedirectsAllowed;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public Collection<String> getTargetPreferredAuthSchemes() {
        return this.targetPreferredAuthSchemes;
    }

    public Collection<String> getProxyPreferredAuthSchemes() {
        return this.proxyPreferredAuthSchemes;
    }

    public Timeout getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    @Deprecated
    public Timeout getConnectTimeout() {
        return this.connectTimeout;
    }

    public Timeout getResponseTimeout() {
        return this.responseTimeout;
    }

    public TimeValue getConnectionKeepAlive() {
        return this.connectionKeepAlive;
    }

    public boolean isContentCompressionEnabled() {
        return this.contentCompressionEnabled;
    }

    public boolean isHardCancellationEnabled() {
        return this.hardCancellationEnabled;
    }

    public boolean isProtocolUpgradeEnabled() {
        return this.protocolUpgradeEnabled;
    }

    protected RequestConfig clone() throws CloneNotSupportedException {
        return (RequestConfig)super.clone();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append("expectContinueEnabled=").append(this.expectContinueEnabled);
        stringBuilder.append(", proxy=").append(this.proxy);
        stringBuilder.append(", cookieSpec=").append(this.cookieSpec);
        stringBuilder.append(", redirectsEnabled=").append(this.redirectsEnabled);
        stringBuilder.append(", maxRedirects=").append(this.maxRedirects);
        stringBuilder.append(", circularRedirectsAllowed=").append(this.circularRedirectsAllowed);
        stringBuilder.append(", authenticationEnabled=").append(this.authenticationEnabled);
        stringBuilder.append(", targetPreferredAuthSchemes=").append(this.targetPreferredAuthSchemes);
        stringBuilder.append(", proxyPreferredAuthSchemes=").append(this.proxyPreferredAuthSchemes);
        stringBuilder.append(", connectionRequestTimeout=").append(this.connectionRequestTimeout);
        stringBuilder.append(", connectTimeout=").append(this.connectTimeout);
        stringBuilder.append(", responseTimeout=").append(this.responseTimeout);
        stringBuilder.append(", connectionKeepAlive=").append(this.connectionKeepAlive);
        stringBuilder.append(", contentCompressionEnabled=").append(this.contentCompressionEnabled);
        stringBuilder.append(", hardCancellationEnabled=").append(this.hardCancellationEnabled);
        stringBuilder.append(", protocolUpgradeEnabled=").append(this.protocolUpgradeEnabled);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static RequestConfig$Builder custom() {
        return new RequestConfig$Builder();
    }

    public static RequestConfig$Builder copy(RequestConfig requestConfig) {
        return new RequestConfig$Builder().setExpectContinueEnabled(requestConfig.isExpectContinueEnabled()).setProxy(requestConfig.getProxy()).setCookieSpec(requestConfig.getCookieSpec()).setRedirectsEnabled(requestConfig.isRedirectsEnabled()).setCircularRedirectsAllowed(requestConfig.isCircularRedirectsAllowed()).setMaxRedirects(requestConfig.getMaxRedirects()).setAuthenticationEnabled(requestConfig.isAuthenticationEnabled()).setTargetPreferredAuthSchemes(requestConfig.getTargetPreferredAuthSchemes()).setProxyPreferredAuthSchemes(requestConfig.getProxyPreferredAuthSchemes()).setConnectionRequestTimeout(requestConfig.getConnectionRequestTimeout()).setConnectTimeout(requestConfig.getConnectTimeout()).setResponseTimeout(requestConfig.getResponseTimeout()).setConnectionKeepAlive(requestConfig.getConnectionKeepAlive()).setContentCompressionEnabled(requestConfig.isContentCompressionEnabled()).setHardCancellationEnabled(requestConfig.isHardCancellationEnabled()).setProtocolUpgradeEnabled(requestConfig.isProtocolUpgradeEnabled());
    }

    static /* synthetic */ Timeout access$000() {
        return DEFAULT_CONNECTION_REQUEST_TIMEOUT;
    }

    static /* synthetic */ TimeValue access$100() {
        return DEFAULT_CONN_KEEP_ALIVE;
    }
}

