/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.config;

import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.util.Timeout;

public class TlsConfig$Builder {
    private Timeout handshakeTimeout;
    private String[] supportedProtocols;
    private String[] supportedCipherSuites;
    private HttpVersionPolicy versionPolicy;

    public TlsConfig$Builder setHandshakeTimeout(Timeout timeout) {
        this.handshakeTimeout = timeout;
        return this;
    }

    public TlsConfig$Builder setHandshakeTimeout(long l2, TimeUnit timeUnit) {
        this.handshakeTimeout = Timeout.of(l2, timeUnit);
        return this;
    }

    public TlsConfig$Builder setSupportedProtocols(String ... stringArray) {
        this.supportedProtocols = stringArray;
        return this;
    }

    public TlsConfig$Builder setSupportedProtocols(TLS ... tLSArray) {
        this.supportedProtocols = new String[tLSArray.length];
        for (int i2 = 0; i2 < tLSArray.length; ++i2) {
            TLS tLS = tLSArray[i2];
            if (tLS == null) continue;
            this.supportedProtocols[i2] = tLS.id;
        }
        return this;
    }

    public TlsConfig$Builder setSupportedCipherSuites(String ... stringArray) {
        this.supportedCipherSuites = stringArray;
        return this;
    }

    public TlsConfig$Builder setVersionPolicy(HttpVersionPolicy httpVersionPolicy) {
        this.versionPolicy = httpVersionPolicy;
        return this;
    }

    public TlsConfig build() {
        return new TlsConfig(this.handshakeTimeout, this.supportedProtocols, this.supportedCipherSuites, this.versionPolicy != null ? this.versionPolicy : HttpVersionPolicy.NEGOTIATE);
    }
}

