/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.apache.hc.client5.http.entity.InputStreamFactory;
import org.apache.hc.core5.io.Closer;

class LazyDecompressingInputStream
extends FilterInputStream {
    private final InputStreamFactory inputStreamFactory;
    private InputStream wrapperStream;

    public LazyDecompressingInputStream(InputStream inputStream, InputStreamFactory inputStreamFactory) {
        super(inputStream);
        this.inputStreamFactory = inputStreamFactory;
    }

    private InputStream initWrapper() throws IOException {
        if (this.wrapperStream == null) {
            this.wrapperStream = this.inputStreamFactory.create(this.in);
        }
        return this.wrapperStream;
    }

    @Override
    public int read() throws IOException {
        return this.initWrapper().read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.initWrapper().read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.initWrapper().read(byArray, n2, n3);
    }

    @Override
    public long skip(long l2) throws IOException {
        return this.initWrapper().skip(l2);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        return this.initWrapper().available();
    }

    @Override
    public void close() throws IOException {
        try {
            Closer.close(this.wrapperStream);
            return;
        }
        finally {
            super.close();
        }
    }

    @Override
    public void mark(int n2) {
        try {
            this.initWrapper().mark(n2);
            return;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void reset() throws IOException {
        this.initWrapper().reset();
    }
}

