/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.client5.http.entity.mime.AbstractContentBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.util.Args;

public class FileBody
extends AbstractContentBody {
    private final File file;
    private final String filename;

    public FileBody(File file) {
        this(file, ContentType.DEFAULT_BINARY, file != null ? file.getName() : null);
    }

    public FileBody(File file, ContentType contentType, String string) {
        super(contentType);
        Args.notNull(file, "File");
        this.file = file;
        this.filename = string == null ? file.getName() : string;
    }

    public FileBody(File file, ContentType contentType) {
        this(file, contentType, file != null ? file.getName() : null);
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        FileInputStream fileInputStream = new FileInputStream(this.file);
        Throwable throwable = null;
        try {
            int n2;
            byte[] byArray = new byte[4096];
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
            outputStream.flush();
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    ((InputStream)fileInputStream).close();
                }
                throw throwable4;
            }
        }
        ((InputStream)fileInputStream).close();
        return;
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public File getFile() {
        return this.file;
    }
}

