/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.Serializable;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.entity.mime.AbstractContentBody;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FormBodyPart;
import org.apache.hc.client5.http.entity.mime.Header;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MimeField;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.PercentCodec;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public class FormBodyPartBuilder {
    private String name;
    private ContentBody body;
    private final Header header = new Header();
    private HttpMultipartMode mode = HttpMultipartMode.STRICT;
    private CharsetEncoder iso8859_1Encoder;

    public static FormBodyPartBuilder create(String string, ContentBody contentBody, HttpMultipartMode httpMultipartMode) {
        return new FormBodyPartBuilder(string, contentBody, httpMultipartMode);
    }

    public static FormBodyPartBuilder create(String string, ContentBody contentBody) {
        return new FormBodyPartBuilder(string, contentBody, HttpMultipartMode.STRICT);
    }

    public static FormBodyPartBuilder create() {
        return new FormBodyPartBuilder();
    }

    FormBodyPartBuilder(String string, ContentBody contentBody, HttpMultipartMode httpMultipartMode) {
        this();
        this.name = string;
        this.body = contentBody;
        this.mode = httpMultipartMode != null ? httpMultipartMode : HttpMultipartMode.STRICT;
    }

    FormBodyPartBuilder() {
    }

    public FormBodyPartBuilder setName(String string) {
        this.name = string;
        return this;
    }

    public FormBodyPartBuilder setBody(ContentBody contentBody) {
        this.body = contentBody;
        return this;
    }

    public FormBodyPartBuilder addField(String string, String string2, List<NameValuePair> list) {
        Args.notNull(string, "Field name");
        this.header.addField(new MimeField(string, string2, list));
        return this;
    }

    public FormBodyPartBuilder addField(String string, String string2) {
        Args.notNull(string, "Field name");
        this.header.addField(new MimeField(string, string2));
        return this;
    }

    public FormBodyPartBuilder setField(String string, String string2) {
        Args.notNull(string, "Field name");
        this.header.setField(new MimeField(string, string2));
        return this;
    }

    public FormBodyPartBuilder removeFields(String string) {
        Args.notNull(string, "Field name");
        this.header.removeFields(string);
        return this;
    }

    private boolean canEncodeToISO8859_1(String string) {
        if (this.iso8859_1Encoder == null) {
            this.iso8859_1Encoder = StandardCharsets.ISO_8859_1.newEncoder();
        }
        return this.iso8859_1Encoder.canEncode(string);
    }

    private static String encodeRFC5987(String string) {
        return "UTF-8''" + PercentCodec.RFC5987.encode(string);
    }

    public FormBodyPart build() {
        Object object;
        Asserts.notBlank(this.name, "Name");
        Asserts.notNull(this.body, "Content body");
        Header header = new Header();
        Serializable serializable = this.header.getFields();
        serializable = serializable.iterator();
        while (serializable.hasNext()) {
            object = (MimeField)serializable.next();
            header.addField((MimeField)object);
        }
        if (header.getField("Content-Disposition") == null) {
            serializable = new ArrayList<BasicNameValuePair>();
            serializable.add(new BasicNameValuePair("name", this.name));
            if (this.body.getFilename() != null) {
                object = this.body.getFilename();
                serializable.add(new BasicNameValuePair("filename", (String)object));
                if (this.mode != HttpMultipartMode.LEGACY && !this.canEncodeToISO8859_1((String)object)) {
                    serializable.add(new BasicNameValuePair("filename*", FormBodyPartBuilder.encodeRFC5987((String)object)));
                }
            }
            header.addField(new MimeField("Content-Disposition", "form-data", (List<NameValuePair>)((Object)serializable)));
        }
        if (header.getField("Content-Type") == null) {
            serializable = this.body instanceof AbstractContentBody ? ((AbstractContentBody)this.body).getContentType() : null;
            if (serializable != null) {
                header.addField(new MimeField("Content-Type", ((ContentType)serializable).toString()));
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append(this.body.getMimeType());
                if (this.body.getCharset() != null) {
                    ((StringBuilder)object).append("; charset=");
                    ((StringBuilder)object).append(this.body.getCharset());
                }
                header.addField(new MimeField("Content-Type", ((StringBuilder)object).toString()));
            }
        }
        return new FormBodyPart(this.name, this.body, header);
    }
}

