/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hc.client5.http.entity.mime.MimeField;

public class Header
implements Iterable<MimeField> {
    private final List<MimeField> fields = new LinkedList<MimeField>();
    private final Map<String, List<MimeField>> fieldMap = new HashMap<String, List<MimeField>>();

    public void addField(MimeField mimeField) {
        if (mimeField == null) {
            return;
        }
        Object object = mimeField.getName().toLowerCase(Locale.ROOT);
        object = this.fieldMap.computeIfAbsent((String)object, string -> new LinkedList());
        object.add(mimeField);
        this.fields.add(mimeField);
    }

    public List<MimeField> getFields() {
        return new ArrayList<MimeField>(this.fields);
    }

    public MimeField getField(String object) {
        if (object == null) {
            return null;
        }
        object = ((String)object).toLowerCase(Locale.ROOT);
        if ((object = this.fieldMap.get(object)) != null && !object.isEmpty()) {
            return (MimeField)object.get(0);
        }
        return null;
    }

    public List<MimeField> getFields(String object) {
        if (object == null) {
            return null;
        }
        object = ((String)object).toLowerCase(Locale.ROOT);
        if ((object = this.fieldMap.get(object)) == null || object.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<MimeField>((Collection<MimeField>)object);
    }

    public int removeFields(String object) {
        if (object == null) {
            return 0;
        }
        object = ((String)object).toLowerCase(Locale.ROOT);
        if ((object = this.fieldMap.remove(object)) == null || object.isEmpty()) {
            return 0;
        }
        this.fields.removeAll((Collection<?>)object);
        return object.size();
    }

    public void setField(MimeField mimeField) {
        if (mimeField == null) {
            return;
        }
        Object object = mimeField.getName().toLowerCase(Locale.ROOT);
        if ((object = this.fieldMap.get(object)) == null || object.isEmpty()) {
            this.addField(mimeField);
            return;
        }
        object.clear();
        object.add(mimeField);
        int n2 = -1;
        int n3 = 0;
        Iterator<MimeField> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            MimeField mimeField2 = iterator.next();
            if (mimeField2.getName().equalsIgnoreCase(mimeField.getName())) {
                iterator.remove();
                if (n2 == -1) {
                    n2 = n3;
                }
            }
            ++n3;
        }
        this.fields.add(n2, mimeField);
    }

    @Override
    public Iterator<MimeField> iterator() {
        return Collections.unmodifiableList(this.fields).iterator();
    }

    public String toString() {
        return this.fields.toString();
    }
}

