/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.client5.http.entity.mime.AbstractContentBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.util.Args;

public class InputStreamBody
extends AbstractContentBody {
    private final InputStream in;
    private final String filename;
    private final long contentLength;

    public InputStreamBody(InputStream inputStream, String string) {
        this(inputStream, ContentType.DEFAULT_BINARY, string);
    }

    public InputStreamBody(InputStream inputStream, ContentType contentType, String string) {
        this(inputStream, contentType, string, -1L);
    }

    public InputStreamBody(InputStream inputStream, ContentType contentType, String string, long l2) {
        super(contentType);
        Args.notNull(inputStream, "Input stream");
        this.in = inputStream;
        this.filename = string;
        this.contentLength = l2 >= 0L ? l2 : -1L;
    }

    public InputStreamBody(InputStream inputStream, ContentType contentType) {
        this(inputStream, contentType, null);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        try {
            int n2;
            byte[] byArray = new byte[4096];
            while ((n2 = this.in.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
            outputStream.flush();
            return;
        }
        finally {
            this.in.close();
        }
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }
}

