/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hc.client5.http.entity.mime.AbstractMultipartFormat;
import org.apache.hc.client5.http.entity.mime.ByteArrayBody;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.FormBodyPart;
import org.apache.hc.client5.http.entity.mime.FormBodyPartBuilder;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.HttpRFC6532Multipart;
import org.apache.hc.client5.http.entity.mime.HttpRFC7578Multipart;
import org.apache.hc.client5.http.entity.mime.HttpStrictMultipart;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.LegacyMultipart;
import org.apache.hc.client5.http.entity.mime.MultipartFormEntity;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartEntityBuilder {
    private ContentType contentType;
    private HttpMultipartMode mode = HttpMultipartMode.STRICT;
    private String boundary;
    private Charset charset;
    private List<MultipartPart> multipartParts;
    private static final String BOUNDARY_PREFIX = "httpclient_boundary_";
    private static final Logger LOG = LoggerFactory.getLogger(MultipartEntityBuilder.class);
    private String preamble;
    private String epilogue;
    private static final NameValuePair[] EMPTY_NAME_VALUE_ARRAY = new NameValuePair[0];

    public static MultipartEntityBuilder create() {
        return new MultipartEntityBuilder();
    }

    MultipartEntityBuilder() {
    }

    public MultipartEntityBuilder setMode(HttpMultipartMode httpMultipartMode) {
        this.mode = httpMultipartMode;
        return this;
    }

    public MultipartEntityBuilder setLaxMode() {
        this.mode = HttpMultipartMode.LEGACY;
        return this;
    }

    public MultipartEntityBuilder setStrictMode() {
        this.mode = HttpMultipartMode.STRICT;
        return this;
    }

    public MultipartEntityBuilder setBoundary(String string) {
        this.boundary = string;
        return this;
    }

    public MultipartEntityBuilder setMimeSubtype(String string) {
        Args.notBlank(string, "MIME subtype");
        this.contentType = ContentType.create("multipart/" + string);
        return this;
    }

    public MultipartEntityBuilder setContentType(ContentType contentType) {
        Args.notNull(contentType, "Content type");
        this.contentType = contentType;
        return this;
    }

    public MultipartEntityBuilder addParameter(BasicNameValuePair basicNameValuePair) {
        this.contentType = this.contentType.withParameters(basicNameValuePair);
        return this;
    }

    public MultipartEntityBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public MultipartEntityBuilder addPart(MultipartPart multipartPart) {
        if (multipartPart == null) {
            return this;
        }
        if (this.multipartParts == null) {
            this.multipartParts = new ArrayList<MultipartPart>();
        }
        this.multipartParts.add(multipartPart);
        return this;
    }

    public MultipartEntityBuilder addPart(String string, ContentBody contentBody) {
        Args.notNull(string, "Name");
        Args.notNull(contentBody, "Content body");
        return this.addPart(FormBodyPartBuilder.create(string, contentBody).build());
    }

    public MultipartEntityBuilder addTextBody(String string, String string2, ContentType contentType) {
        return this.addPart(string, new StringBody(string2, contentType));
    }

    public MultipartEntityBuilder addTextBody(String string, String string2) {
        return this.addTextBody(string, string2, ContentType.DEFAULT_TEXT);
    }

    public MultipartEntityBuilder addBinaryBody(String string, byte[] byArray, ContentType contentType, String string2) {
        return this.addPart(string, new ByteArrayBody(byArray, contentType, string2));
    }

    public MultipartEntityBuilder addBinaryBody(String string, byte[] byArray) {
        return this.addPart(string, new ByteArrayBody(byArray, ContentType.DEFAULT_BINARY));
    }

    public MultipartEntityBuilder addBinaryBody(String string, File file, ContentType contentType, String string2) {
        return this.addPart(string, new FileBody(file, contentType, string2));
    }

    public MultipartEntityBuilder addBinaryBody(String string, File file) {
        return this.addBinaryBody(string, file, ContentType.DEFAULT_BINARY, file != null ? file.getName() : null);
    }

    public MultipartEntityBuilder addBinaryBody(String string, InputStream inputStream, ContentType contentType, String string2) {
        return this.addPart(string, new InputStreamBody(inputStream, contentType, string2));
    }

    public MultipartEntityBuilder addBinaryBody(String string, InputStream inputStream) {
        return this.addBinaryBody(string, inputStream, ContentType.DEFAULT_BINARY, null);
    }

    private String getRandomBoundary() {
        return BOUNDARY_PREFIX + UUID.randomUUID();
    }

    public MultipartEntityBuilder addPreamble(String string) {
        this.preamble = string;
        return this;
    }

    public MultipartEntityBuilder addEpilogue(String string) {
        this.epilogue = string;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    MultipartFormEntity buildEntity() {
        void var6_12;
        Charset charset;
        String string = this.boundary;
        if (string == null && this.contentType != null) {
            string = this.contentType.getParameter("boundary");
        }
        if (string == null) {
            string = this.getRandomBoundary();
        }
        if ((charset = this.charset) == null && this.contentType != null) {
            charset = this.contentType.getCharset();
        }
        Object object2 = new NameValuePair[]{new BasicNameValuePair("boundary", string)};
        if (this.contentType != null) {
            object2 = this.contentType.withParameters((NameValuePair[])object2);
        } else {
            boolean bl2 = false;
            if (this.multipartParts != null) {
                for (MultipartPart object3 : this.multipartParts) {
                    if (!(object3 instanceof FormBodyPart)) continue;
                    bl2 = true;
                    break;
                }
            }
            object2 = bl2 ? ContentType.MULTIPART_FORM_DATA.withParameters((NameValuePair[])object2) : ContentType.create("multipart/mixed", (NameValuePair[])object2);
        }
        ArrayList<MultipartPart> arrayList = this.multipartParts != null ? new ArrayList<MultipartPart>(this.multipartParts) : Collections.emptyList();
        HttpMultipartMode httpMultipartMode = this.mode != null ? this.mode : HttpMultipartMode.STRICT;
        switch (httpMultipartMode) {
            case LEGACY: {
                LegacyMultipart legacyMultipart = new LegacyMultipart(charset, string, arrayList);
                break;
            }
            case EXTENDED: {
                if (((ContentType)object2).isSameMimeType(ContentType.MULTIPART_FORM_DATA)) {
                    if (charset == null) {
                        charset = StandardCharsets.UTF_8;
                    }
                    HttpRFC7578Multipart httpRFC7578Multipart = new HttpRFC7578Multipart(charset, string, arrayList, this.preamble, this.epilogue, httpMultipartMode);
                    break;
                }
                HttpRFC6532Multipart httpRFC6532Multipart = new HttpRFC6532Multipart(charset, string, arrayList, this.preamble, this.epilogue);
                break;
            }
            default: {
                HttpStrictMultipart httpStrictMultipart = new HttpStrictMultipart(StandardCharsets.US_ASCII, string, arrayList, this.preamble, this.epilogue);
            }
        }
        return new MultipartFormEntity((AbstractMultipartFormat)var6_12, (ContentType)object2, var6_12.getTotalLength());
    }

    public HttpEntity build() {
        return this.buildEntity();
    }
}

