/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.util.List;
import org.apache.hc.client5.http.entity.mime.AbstractContentBody;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.Header;
import org.apache.hc.client5.http.entity.mime.MimeField;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public class MultipartPartBuilder {
    private ContentBody body;
    private final Header header = new Header();

    public static MultipartPartBuilder create(ContentBody contentBody) {
        return new MultipartPartBuilder(contentBody);
    }

    public static MultipartPartBuilder create() {
        return new MultipartPartBuilder();
    }

    MultipartPartBuilder(ContentBody contentBody) {
        this();
        this.body = contentBody;
    }

    MultipartPartBuilder() {
    }

    public MultipartPartBuilder setBody(ContentBody contentBody) {
        this.body = contentBody;
        return this;
    }

    public MultipartPartBuilder addHeader(String string, String string2, List<NameValuePair> list) {
        Args.notNull(string, "Header name");
        this.header.addField(new MimeField(string, string2, list));
        return this;
    }

    public MultipartPartBuilder addHeader(String string, String string2) {
        Args.notNull(string, "Header name");
        this.header.addField(new MimeField(string, string2));
        return this;
    }

    public MultipartPartBuilder setHeader(String string, String string2) {
        Args.notNull(string, "Header name");
        this.header.setField(new MimeField(string, string2));
        return this;
    }

    public MultipartPartBuilder removeHeaders(String string) {
        Args.notNull(string, "Header name");
        this.header.removeFields(string);
        return this;
    }

    public MultipartPart build() {
        Object object;
        Asserts.notNull(this.body, "Content body");
        Header header = new Header();
        Object object2 = this.header.getFields();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (MimeField)object2.next();
            header.addField((MimeField)object);
        }
        if (header.getField("Content-Type") == null) {
            object2 = this.body instanceof AbstractContentBody ? ((AbstractContentBody)this.body).getContentType() : null;
            if (object2 != null) {
                header.addField(new MimeField("Content-Type", ((ContentType)object2).toString()));
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append(this.body.getMimeType());
                if (this.body.getCharset() != null) {
                    ((StringBuilder)object).append("; charset=");
                    ((StringBuilder)object).append(this.body.getCharset());
                }
                header.addField(new MimeField("Content-Type", ((StringBuilder)object).toString()));
            }
        }
        return new MultipartPart(this.body, header);
    }
}

