/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultAuthenticationStrategy
implements AuthenticationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthenticationStrategy.class);
    public static final DefaultAuthenticationStrategy INSTANCE = new DefaultAuthenticationStrategy();
    private static final List<String> DEFAULT_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("Bearer", "Digest", "Basic"));

    protected List<String> getSchemePriority() {
        return DEFAULT_SCHEME_PRIORITY;
    }

    @Override
    public List<AuthScheme> select(ChallengeType object, Map<String, AuthChallenge> map, HttpContext httpContext) {
        Args.notNull(object, "ChallengeType");
        Args.notNull(map, "Map of auth challenges");
        Args.notNull(httpContext, "HTTP context");
        Object object2 = HttpClientContext.cast(httpContext);
        String string = ((HttpClientContext)object2).getExchangeId();
        ArrayList<AuthScheme> arrayList = new ArrayList<AuthScheme>();
        Lookup<AuthSchemeFactory> lookup = ((HttpClientContext)object2).getAuthSchemeRegistry();
        if (lookup == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Auth scheme registry not set in the context", (Object)string);
            }
            return arrayList;
        }
        object2 = ((HttpClientContext)object2).getRequestConfigOrDefault();
        if ((object = object == ChallengeType.TARGET ? ((RequestConfig)object2).getTargetPreferredAuthSchemes() : ((RequestConfig)object2).getProxyPreferredAuthSchemes()) == null) {
            object = this.getSchemePriority();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} Authentication schemes in the order of preference: {}", (Object)string, object);
        }
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (String)object.next();
            Object object3 = map.get(((String)object2).toLowerCase(Locale.ROOT));
            if (object3 != null) {
                object3 = lookup.lookup((String)object2);
                if (object3 == null) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("{} Authentication scheme {} not supported", (Object)string, object2);
                    continue;
                }
                object2 = object3.create(httpContext);
                arrayList.add((AuthScheme)object2);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("{} Challenge for {} authentication scheme not available", (Object)string, object2);
        }
        return arrayList;
    }
}

