/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultRedirectStrategy
implements RedirectStrategy {
    private final SchemePortResolver schemePortResolver;
    public static final DefaultRedirectStrategy INSTANCE = new DefaultRedirectStrategy();

    @Internal
    public DefaultRedirectStrategy(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public DefaultRedirectStrategy() {
        this(null);
    }

    @Override
    public boolean isRedirectAllowed(HttpHost object, HttpHost object2, HttpRequest httpRequest, HttpContext httpContext) {
        if (!this.isSameAuthority((HttpHost)object, (HttpHost)object2)) {
            object = httpRequest.headerIterator();
            while (object.hasNext()) {
                object2 = (Header)object.next();
                if (!object2.isSensitive() && !object2.getName().equalsIgnoreCase("Authorization") && !object2.getName().equalsIgnoreCase("Cookie")) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSameAuthority(HttpHost httpHost, HttpHost httpHost2) {
        int n2;
        String string;
        if (httpHost == null || httpHost2 == null) {
            return false;
        }
        String string2 = httpHost.getHostName();
        if (!string2.equalsIgnoreCase(string = httpHost2.getHostName())) {
            return false;
        }
        int n3 = this.schemePortResolver.resolve(httpHost);
        return n3 == (n2 = this.schemePortResolver.resolve(httpHost2));
    }

    @Override
    public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(httpResponse, "HTTP response");
        if (!httpResponse.containsHeader("Location")) {
            return false;
        }
        int n2 = httpResponse.getCode();
        switch (n2) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    @Override
    public URI getLocationURI(HttpRequest httpRequest, HttpResponse object, HttpContext httpContext) throws HttpException {
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(object, "HTTP response");
        Args.notNull(httpContext, "HTTP context");
        object = object.getFirstHeader("Location");
        if (object == null) {
            throw new HttpException("Redirect location is missing");
        }
        object = object.getValue();
        object = this.createLocationURI((String)object);
        try {
            if (!((URI)object).isAbsolute()) {
                object = URIUtils.resolve(httpRequest.getUri(), (URI)object);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
        return object;
    }

    protected URI createLocationURI(String string) throws ProtocolException {
        try {
            URIBuilder uRIBuilder = new URIBuilder(new URI(string).normalize());
            String string2 = uRIBuilder.getHost();
            if (string2 != null) {
                uRIBuilder.setHost(string2.toLowerCase(Locale.ROOT));
            }
            if (uRIBuilder.isPathEmpty()) {
                uRIBuilder.setPathSegments("");
            }
            return uRIBuilder.build();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid redirect URI: " + string, uRISyntaxException);
        }
    }
}

