/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.STATELESS)
public class LaxRedirectStrategy
extends DefaultRedirectStrategy {
    public static final LaxRedirectStrategy INSTANCE = new LaxRedirectStrategy();
    private static final String[] REDIRECT_METHODS = new String[]{"GET", "POST", "HEAD", "DELETE"};

    @Override
    public boolean isRedirected(HttpRequest object, HttpResponse object2, HttpContext httpContext) {
        if (!object2.containsHeader("Location")) {
            return false;
        }
        int n2 = object2.getCode();
        object = object.getMethod();
        object2 = object2.getFirstHeader("location");
        switch (n2) {
            case 302: {
                return this.isRedirectable((String)object) && object2 != null;
            }
            case 301: 
            case 307: {
                return this.isRedirectable((String)object);
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    protected boolean isRedirectable(String string) {
        String[] stringArray = REDIRECT_METHODS;
        int n2 = REDIRECT_METHODS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

