/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.impl.ProtocolSwitchStrategy$HeaderConsumer;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.ProtocolVersionParser;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

@Internal
public final class ProtocolSwitchStrategy {
    private static final ProtocolVersionParser PROTOCOL_VERSION_PARSER = ProtocolVersionParser.INSTANCE;
    private static final Tokenizer TOKENIZER = Tokenizer.INSTANCE;
    private static final Tokenizer$Delimiter UPGRADE_TOKEN_DELIMITER = Tokenizer.delimiters(',');
    private static final Tokenizer$Delimiter LAX_PROTO_DELIMITER = Tokenizer.delimiters('/', ',');

    public final ProtocolVersion switchProtocol(HttpMessage object2) throws ProtocolException {
        AtomicReference atomicReference = new AtomicReference();
        this.parseHeaders((HttpMessage)object2, "Upgrade", (object, parserCursor) -> {
            if ((object = this.parseProtocolVersion(object, parserCursor)) != null) {
                if ("TLS".equalsIgnoreCase(((ProtocolVersion)((Object)object)).getProtocol())) {
                    atomicReference.set(object);
                    return;
                }
                if (!((ProtocolVersion)((Object)object)).equals(HttpVersion.HTTP_1_1)) {
                    throw new ProtocolException("Unsupported protocol or HTTP version: " + object);
                }
            }
        });
        object2 = (ProtocolVersion)atomicReference.get();
        if (object2 != null) {
            return object2;
        }
        throw new ProtocolException("Invalid protocol switch response: no TLS version found");
    }

    private ProtocolVersion parseProtocolVersion(CharSequence charSequence, ParserCursor parserCursor) throws ProtocolException {
        char c2;
        TOKENIZER.skipWhiteSpace(charSequence, parserCursor);
        String string = TOKENIZER.parseToken(charSequence, (Tokenizer$Cursor)parserCursor, LAX_PROTO_DELIMITER);
        if (!parserCursor.atEnd() && (c2 = charSequence.charAt(parserCursor.getPos())) == '/') {
            if (string.isEmpty()) {
                throw new ParseException("Invalid protocol", charSequence, parserCursor.getLowerBound(), parserCursor.getUpperBound(), parserCursor.getPos());
            }
            ParserCursor parserCursor2 = parserCursor;
            parserCursor2.updatePos(parserCursor2.getPos() + 1);
            return PROTOCOL_VERSION_PARSER.parse(string, null, charSequence, parserCursor, UPGRADE_TOKEN_DELIMITER);
        }
        if (string.isEmpty()) {
            return null;
        }
        if (string.equalsIgnoreCase("TLS")) {
            return TLS.V_1_2.getVersion();
        }
        throw new ProtocolException("Unsupported or invalid protocol: " + string);
    }

    private void parseHeaders(HttpMessage object, String string, ProtocolSwitchStrategy$HeaderConsumer protocolSwitchStrategy$HeaderConsumer) throws ProtocolException {
        object = object.headerIterator(string);
        while (object.hasNext()) {
            this.parseHeader((Header)object.next(), protocolSwitchStrategy$HeaderConsumer);
        }
    }

    private void parseHeader(Header header, ProtocolSwitchStrategy$HeaderConsumer protocolSwitchStrategy$HeaderConsumer) throws ProtocolException {
        Args.notNull(header, "Header");
        if (header instanceof FormattedHeader) {
            CharArrayBuffer charArrayBuffer = ((FormattedHeader)header).getBuffer();
            ParserCursor parserCursor = new ParserCursor(0, charArrayBuffer.length());
            parserCursor.updatePos(((FormattedHeader)header).getValuePos());
            this.parseHeaderElements(charArrayBuffer, parserCursor, protocolSwitchStrategy$HeaderConsumer);
            return;
        }
        String string = header.getValue();
        if (string == null) {
            return;
        }
        ParserCursor parserCursor = new ParserCursor(0, string.length());
        this.parseHeaderElements(string, parserCursor, protocolSwitchStrategy$HeaderConsumer);
    }

    private void parseHeaderElements(CharSequence charSequence, ParserCursor parserCursor, ProtocolSwitchStrategy$HeaderConsumer protocolSwitchStrategy$HeaderConsumer) throws ProtocolException {
        while (!parserCursor.atEnd()) {
            char c2;
            protocolSwitchStrategy$HeaderConsumer.accept(charSequence, parserCursor);
            if (parserCursor.atEnd() || (c2 = charSequence.charAt(parserCursor.getPos())) != ',') continue;
            ParserCursor parserCursor2 = parserCursor;
            parserCursor2.updatePos(parserCursor2.getPos() + 1);
        }
    }
}

