/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChain$Scope;
import org.apache.hc.client5.http.impl.async.AsyncHttpRequestRetryExec;
import org.apache.hc.client5.http.impl.async.AsyncHttpRequestRetryExec$State;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.DiscardingEntityConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;

class AsyncHttpRequestRetryExec$1
implements AsyncExecCallback {
    final /* synthetic */ AsyncExecChain$Scope val$scope;
    final /* synthetic */ AsyncEntityProducer val$entityProducer;
    final /* synthetic */ String val$exchangeId;
    final /* synthetic */ AsyncExecCallback val$asyncExecCallback;
    final /* synthetic */ AsyncHttpRequestRetryExec$State val$state;
    final /* synthetic */ HttpRequest val$request;
    final /* synthetic */ AsyncExecChain val$chain;
    final /* synthetic */ AsyncHttpRequestRetryExec this$0;

    AsyncHttpRequestRetryExec$1(AsyncHttpRequestRetryExec asyncHttpRequestRetryExec, AsyncExecChain$Scope asyncExecChain$Scope, AsyncEntityProducer asyncEntityProducer, String string, AsyncExecCallback asyncExecCallback, AsyncHttpRequestRetryExec$State state, HttpRequest httpRequest, AsyncExecChain asyncExecChain) {
        this.this$0 = asyncHttpRequestRetryExec;
        this.val$scope = asyncExecChain$Scope;
        this.val$entityProducer = asyncEntityProducer;
        this.val$exchangeId = string;
        this.val$asyncExecCallback = asyncExecCallback;
        this.val$state = state;
        this.val$request = httpRequest;
        this.val$chain = asyncExecChain;
    }

    @Override
    public AsyncDataConsumer handleResponse(HttpResponse httpResponse, EntityDetails entityDetails) throws HttpException, IOException {
        HttpClientContext httpClientContext = this.val$scope.clientContext;
        if (this.val$entityProducer != null && !this.val$entityProducer.isRepeatable()) {
            if (AsyncHttpRequestRetryExec.access$000().isDebugEnabled()) {
                AsyncHttpRequestRetryExec.access$000().debug("{} cannot retry non-repeatable request", (Object)this.val$exchangeId);
            }
            return this.val$asyncExecCallback.handleResponse(httpResponse, entityDetails);
        }
        this.val$state.retrying = AsyncHttpRequestRetryExec.access$100(this.this$0).retryRequest(httpResponse, this.val$scope.execCount.get(), httpClientContext);
        if (this.val$state.retrying) {
            this.val$state.status = httpResponse.getCode();
            this.val$state.delay = AsyncHttpRequestRetryExec.access$100(this.this$0).getRetryInterval(httpResponse, this.val$scope.execCount.get(), httpClientContext);
            return new DiscardingEntityConsumer();
        }
        return this.val$asyncExecCallback.handleResponse(httpResponse, entityDetails);
    }

    @Override
    public void handleInformationResponse(HttpResponse httpResponse) throws HttpException, IOException {
        this.val$asyncExecCallback.handleInformationResponse(httpResponse);
    }

    @Override
    public void completed() {
        if (this.val$state.retrying) {
            TimeValue timeValue;
            int n2 = this.val$scope.execCount.incrementAndGet();
            if (this.val$entityProducer != null) {
                this.val$entityProducer.releaseResources();
            }
            HttpHost httpHost = this.val$scope.route.getTargetHost();
            TimeValue timeValue2 = timeValue = TimeValue.isPositive(this.val$state.delay) ? this.val$state.delay : TimeValue.ZERO_MILLISECONDS;
            if (AsyncHttpRequestRetryExec.access$000().isInfoEnabled()) {
                AsyncHttpRequestRetryExec.access$000().info("{} {} responded with status {}; request will be automatically re-executed in {} (exec count {})", this.val$exchangeId, httpHost, this.val$state.status, timeValue, n2);
            }
            AsyncHttpRequestRetryExec$1 asyncHttpRequestRetryExec$1 = this;
            this.val$scope.scheduler.scheduleExecution(this.val$request, this.val$entityProducer, this.val$scope, (httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecCallback) -> this.this$0.execute(httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncHttpRequestRetryExec$1.val$chain, asyncExecCallback), this.val$asyncExecCallback, timeValue);
            return;
        }
        this.val$asyncExecCallback.completed();
    }

    @Override
    public void failed(Exception exception) {
        if (exception instanceof IOException) {
            HttpHost httpHost = this.val$scope.route.getTargetHost();
            Object object = this.val$scope.clientContext;
            if (this.val$entityProducer != null && !this.val$entityProducer.isRepeatable()) {
                if (AsyncHttpRequestRetryExec.access$000().isDebugEnabled()) {
                    AsyncHttpRequestRetryExec.access$000().debug("{} cannot retry non-repeatable request", (Object)this.val$exchangeId);
                }
            } else if (AsyncHttpRequestRetryExec.access$100(this.this$0).retryRequest(this.val$request, (IOException)exception, this.val$scope.execCount.get(), (HttpContext)object)) {
                if (AsyncHttpRequestRetryExec.access$000().isDebugEnabled()) {
                    AsyncHttpRequestRetryExec.access$000().debug("{} {}", this.val$exchangeId, exception.getMessage(), exception);
                }
                this.val$scope.execRuntime.discardEndpoint();
                if (this.val$entityProducer != null) {
                    this.val$entityProducer.releaseResources();
                }
                this.val$state.retrying = true;
                int n2 = this.val$scope.execCount.incrementAndGet();
                this.val$state.delay = AsyncHttpRequestRetryExec.access$100(this.this$0).getRetryInterval(this.val$request, (IOException)exception, n2 - 1, (HttpContext)object);
                Object object2 = object = TimeValue.isPositive(this.val$state.delay) ? this.val$state.delay : TimeValue.ZERO_MILLISECONDS;
                if (AsyncHttpRequestRetryExec.access$000().isInfoEnabled()) {
                    AsyncHttpRequestRetryExec.access$000().info("{} recoverable I/O exception ({}) caught when sending request to {};request will be automatically re-executed in {} (exec count {})", this.val$exchangeId, exception.getClass().getName(), httpHost, object, n2);
                }
                AsyncHttpRequestRetryExec$1 asyncHttpRequestRetryExec$1 = this;
                this.val$scope.scheduler.scheduleExecution(this.val$request, this.val$entityProducer, this.val$scope, (httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecCallback) -> this.this$0.execute(httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncHttpRequestRetryExec$1.val$chain, asyncExecCallback), this.val$asyncExecCallback, (TimeValue)object);
                return;
            }
        }
        this.val$asyncExecCallback.failed(exception);
    }
}

