/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChain$Scope;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.RequestSupport;
import org.apache.hc.client5.http.impl.async.AsyncProtocolExec$1;
import org.apache.hc.client5.http.impl.auth.AuthCacheKeeper;
import org.apache.hc.client5.http.impl.auth.AuthenticationHandler;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.support.AbstractRequestBuilder;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class AsyncProtocolExec
implements AsyncExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncProtocolExec.class);
    private final AuthenticationStrategy targetAuthStrategy;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final AuthenticationHandler authenticator;
    private final SchemePortResolver schemePortResolver;
    private final AuthCacheKeeper authCacheKeeper;

    AsyncProtocolExec(AuthenticationStrategy authenticationStrategy, AuthenticationStrategy authenticationStrategy2, SchemePortResolver schemePortResolver, boolean bl2) {
        this.targetAuthStrategy = Args.notNull(authenticationStrategy, "Target authentication strategy");
        this.proxyAuthStrategy = Args.notNull(authenticationStrategy2, "Proxy authentication strategy");
        this.authenticator = new AuthenticationHandler();
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.authCacheKeeper = bl2 ? null : new AuthCacheKeeper(this.schemePortResolver);
    }

    @Override
    public final void execute(HttpRequest httpRequest, AsyncEntityProducer asyncEntityProducer, AsyncExecChain$Scope asyncExecChain$Scope, AsyncExecChain asyncExecChain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        AuthExchange authExchange;
        if (Method.CONNECT.isSame(httpRequest.getMethod())) {
            throw new ProtocolException("Direct execution of CONNECT is not allowed");
        }
        Object object = asyncExecChain$Scope.route;
        Object object2 = ((HttpRoute)object).getTargetHost();
        Serializable serializable = ((HttpRoute)object).getProxyHost();
        HttpClientContext httpClientContext = asyncExecChain$Scope.clientContext;
        if (serializable != null && !((HttpRoute)object).isTunnelled()) {
            object = BasicRequestBuilder.copy(httpRequest);
            if (((AbstractRequestBuilder)object).getAuthority() == null) {
                ((BasicRequestBuilder)object).setAuthority(new URIAuthority((NamedEndpoint)object2));
            }
            ((BasicRequestBuilder)object).setAbsoluteRequestUri(true);
            httpRequest = ((BasicRequestBuilder)object).build();
        }
        if (httpRequest.getScheme() == null) {
            httpRequest.setScheme(((HttpHost)object2).getSchemeName());
        }
        if (httpRequest.getAuthority() == null) {
            httpRequest.setAuthority(new URIAuthority((NamedEndpoint)object2));
        }
        if (((URIAuthority)(object = httpRequest.getAuthority())).getUserInfo() != null) {
            throw new ProtocolException("Request URI authority contains deprecated userinfo component");
        }
        object = new HttpHost(httpRequest.getScheme(), ((URIAuthority)object).getHostName(), this.schemePortResolver.resolve(httpRequest.getScheme(), (NamedEndpoint)object));
        object2 = RequestSupport.extractPathPrefix(httpRequest);
        AuthExchange authExchange2 = httpClientContext.getAuthExchange((HttpHost)object);
        AuthExchange authExchange3 = authExchange = serializable != null ? httpClientContext.getAuthExchange((HttpHost)serializable) : new AuthExchange();
        if (!authExchange2.isConnectionBased() && authExchange2.getPathPrefix() != null && !((String)object2).startsWith(authExchange2.getPathPrefix())) {
            authExchange2.reset();
        }
        if (authExchange2.getPathPrefix() == null) {
            authExchange2.setPathPrefix((String)object2);
        }
        if (this.authCacheKeeper != null) {
            this.authCacheKeeper.loadPreemptively((HttpHost)object, (String)object2, authExchange2, httpClientContext);
            if (serializable != null) {
                this.authCacheKeeper.loadPreemptively((HttpHost)serializable, null, authExchange, httpClientContext);
            }
        }
        serializable = new AtomicBoolean(false);
        this.internalExecute((HttpHost)object, (String)object2, authExchange2, authExchange, (AtomicBoolean)serializable, httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, asyncExecCallback);
    }

    private void internalExecute(HttpHost httpHost, String string, AuthExchange authExchange, AuthExchange authExchange2, AtomicBoolean atomicBoolean, HttpRequest httpRequest, AsyncEntityProducer asyncEntityProducer, AsyncExecChain$Scope asyncExecChain$Scope, AsyncExecChain asyncExecChain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        String string2 = asyncExecChain$Scope.exchangeId;
        HttpRoute httpRoute = asyncExecChain$Scope.route;
        HttpClientContext httpClientContext = asyncExecChain$Scope.clientContext;
        AsyncExecRuntime asyncExecRuntime = asyncExecChain$Scope.execRuntime;
        HttpHost httpHost2 = httpRoute.getProxyHost();
        if (!httpRequest.containsHeader("Authorization")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} target auth state: {}", (Object)string2, (Object)authExchange.getState());
            }
            this.authenticator.addAuthResponse(httpHost, ChallengeType.TARGET, httpRequest, authExchange, httpClientContext);
        }
        if (!httpRequest.containsHeader("Proxy-Authorization") && !httpRoute.isTunnelled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} proxy auth state: {}", (Object)string2, (Object)authExchange2.getState());
            }
            this.authenticator.addAuthResponse(httpHost2, ChallengeType.PROXY, httpRequest, authExchange2, httpClientContext);
        }
        asyncExecChain.proceed(httpRequest, asyncEntityProducer, asyncExecChain$Scope, new AsyncProtocolExec$1(this, httpRequest, asyncExecCallback, authExchange, authExchange2, httpHost2, httpHost, string, httpClientContext, atomicBoolean, asyncExecRuntime, string2, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain));
    }

    private boolean needAuthentication(AuthExchange authExchange, AuthExchange authExchange2, HttpHost httpHost, HttpHost httpHost2, String string, HttpResponse httpResponse, HttpClientContext httpClientContext) throws AuthenticationException, MalformedChallengeException {
        RequestConfig requestConfig = httpClientContext.getRequestConfigOrDefault();
        if (requestConfig.isAuthenticationEnabled()) {
            boolean bl2 = this.authenticator.isChallenged(httpHost2, ChallengeType.TARGET, httpResponse, authExchange, httpClientContext);
            boolean bl3 = this.authenticator.isChallengeExpected(authExchange);
            if (this.authCacheKeeper != null) {
                if (bl2) {
                    this.authCacheKeeper.updateOnChallenge(httpHost2, string, authExchange, httpClientContext);
                } else {
                    this.authCacheKeeper.updateOnNoChallenge(httpHost2, string, authExchange, httpClientContext);
                }
            }
            boolean bl4 = this.authenticator.isChallenged(httpHost, ChallengeType.PROXY, httpResponse, authExchange2, httpClientContext);
            boolean bl5 = this.authenticator.isChallengeExpected(authExchange2);
            if (this.authCacheKeeper != null) {
                if (bl4) {
                    this.authCacheKeeper.updateOnChallenge(httpHost, null, authExchange2, httpClientContext);
                } else {
                    this.authCacheKeeper.updateOnNoChallenge(httpHost, null, authExchange2, httpClientContext);
                }
            }
            if (bl2 || bl3) {
                boolean bl6 = this.authenticator.handleResponse(httpHost2, ChallengeType.TARGET, httpResponse, this.targetAuthStrategy, authExchange, httpClientContext);
                if (this.authCacheKeeper != null) {
                    this.authCacheKeeper.updateOnResponse(httpHost2, string, authExchange, httpClientContext);
                }
                return bl6;
            }
            if (bl4 || bl5) {
                boolean bl7 = this.authenticator.handleResponse(httpHost, ChallengeType.PROXY, httpResponse, this.proxyAuthStrategy, authExchange2, httpClientContext);
                if (this.authCacheKeeper != null) {
                    this.authCacheKeeper.updateOnResponse(httpHost, null, authExchange2, httpClientContext);
                }
                return bl7;
            }
        }
        return false;
    }

    static /* synthetic */ boolean access$000(AsyncProtocolExec asyncProtocolExec, AuthExchange authExchange, AuthExchange authExchange2, HttpHost httpHost, HttpHost httpHost2, String string, HttpResponse httpResponse, HttpClientContext httpClientContext) throws AuthenticationException, MalformedChallengeException {
        return asyncProtocolExec.needAuthentication(authExchange, authExchange2, httpHost, httpHost2, string, httpResponse, httpClientContext);
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static /* synthetic */ void access$200(AsyncProtocolExec asyncProtocolExec, HttpHost httpHost, String string, AuthExchange authExchange, AuthExchange authExchange2, AtomicBoolean atomicBoolean, HttpRequest httpRequest, AsyncEntityProducer asyncEntityProducer, AsyncExecChain$Scope asyncExecChain$Scope, AsyncExecChain asyncExecChain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        asyncProtocolExec.internalExecute(httpHost, string, authExchange, authExchange2, atomicBoolean, httpRequest, asyncEntityProducer, asyncExecChain$Scope, asyncExecChain, asyncExecCallback);
    }
}

