/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.apache.hc.client5.http.CircularRedirectException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RedirectException;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChain$Scope;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.AsyncRedirectExec;
import org.apache.hc.client5.http.impl.async.AsyncRedirectExec$State;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.support.BasicRequestBuilder;

class AsyncRedirectExec$1
implements AsyncExecCallback {
    final /* synthetic */ AsyncRedirectExec$State val$state;
    final /* synthetic */ HttpClientContext val$clientContext;
    final /* synthetic */ HttpRequest val$request;
    final /* synthetic */ String val$exchangeId;
    final /* synthetic */ AsyncExecCallback val$asyncExecCallback;
    final /* synthetic */ AsyncExecChain$Scope val$scope;
    final /* synthetic */ AsyncExecChain val$chain;
    final /* synthetic */ AsyncRedirectExec this$0;

    AsyncRedirectExec$1(AsyncRedirectExec asyncRedirectExec, AsyncRedirectExec$State state, HttpClientContext httpClientContext, HttpRequest httpRequest, String string, AsyncExecCallback asyncExecCallback, AsyncExecChain$Scope asyncExecChain$Scope, AsyncExecChain asyncExecChain) {
        this.this$0 = asyncRedirectExec;
        this.val$state = state;
        this.val$clientContext = httpClientContext;
        this.val$request = httpRequest;
        this.val$exchangeId = string;
        this.val$asyncExecCallback = asyncExecCallback;
        this.val$scope = asyncExecChain$Scope;
        this.val$chain = asyncExecChain;
    }

    @Override
    public AsyncDataConsumer handleResponse(HttpResponse object, EntityDetails object2) throws HttpException, IOException {
        this.val$state.redirectURI = null;
        Object object3 = this.val$clientContext.getRequestConfigOrDefault();
        if (((RequestConfig)object3).isRedirectsEnabled() && AsyncRedirectExec.access$000(this.this$0).isRedirected(this.val$request, (HttpResponse)object, this.val$clientContext)) {
            Object object4;
            if (this.val$state.redirectCount >= this.val$state.maxRedirects) {
                throw new RedirectException("Maximum redirects (" + this.val$state.maxRedirects + ") exceeded");
            }
            ++this.val$state.redirectCount;
            URI uRI = AsyncRedirectExec.access$000(this.this$0).getLocationURI(this.val$request, (HttpResponse)object, this.val$clientContext);
            if (AsyncRedirectExec.access$100().isDebugEnabled()) {
                AsyncRedirectExec.access$100().debug("{} redirect requested to location '{}'", (Object)this.val$exchangeId, (Object)uRI);
            }
            if (!((RequestConfig)object3).isCircularRedirectsAllowed() && this.val$state.redirectLocations.contains(uRI)) {
                throw new CircularRedirectException("Circular redirect to '" + uRI + "'");
            }
            object3 = this.val$state.currentScope;
            HttpHost httpHost = URIUtils.extractHost(uRI);
            if (httpHost == null) {
                throw new ProtocolException("Redirect URI does not specify a valid host name: " + uRI);
            }
            int n2 = object.getCode();
            switch (n2) {
                case 301: 
                case 302: {
                    if (Method.POST.isSame(this.val$request.getMethod())) {
                        object4 = BasicRequestBuilder.get();
                        this.val$state.currentEntityProducer = null;
                        break;
                    }
                    object4 = BasicRequestBuilder.copy(((AsyncExecChain$Scope)object3).originalRequest);
                    break;
                }
                case 303: {
                    if (!Method.GET.isSame(this.val$request.getMethod()) && !Method.HEAD.isSame(this.val$request.getMethod())) {
                        object4 = BasicRequestBuilder.get();
                        this.val$state.currentEntityProducer = null;
                        break;
                    }
                    object4 = BasicRequestBuilder.copy(((AsyncExecChain$Scope)object3).originalRequest);
                    break;
                }
                default: {
                    object4 = BasicRequestBuilder.copy(((AsyncExecChain$Scope)object3).originalRequest);
                }
            }
            ((BasicRequestBuilder)object4).setUri(uRI);
            object4 = ((BasicRequestBuilder)object4).build();
            object3 = ((AsyncExecChain$Scope)object3).route;
            HttpHost httpHost2 = ((HttpRoute)object3).getTargetHost();
            if (!AsyncRedirectExec.access$000(this.this$0).isRedirectAllowed(httpHost2, httpHost, (HttpRequest)object4, this.val$clientContext)) {
                if (AsyncRedirectExec.access$100().isDebugEnabled()) {
                    AsyncRedirectExec.access$100().debug("{} cannot redirect due to safety restrictions", (Object)this.val$exchangeId);
                }
                return this.val$asyncExecCallback.handleResponse((HttpResponse)object, (EntityDetails)object2);
            }
            this.val$state.redirectLocations.add(uRI);
            this.val$state.reroute = false;
            this.val$state.redirectURI = uRI;
            this.val$state.currentRequest = object4;
            if (!Objects.equals(httpHost2, httpHost)) {
                object = AsyncRedirectExec.access$200(this.this$0).determineRoute(httpHost, this.val$clientContext);
                if (!Objects.equals(object3, object)) {
                    this.val$state.reroute = true;
                    object2 = this.val$clientContext.getAuthExchange(httpHost2);
                    if (AsyncRedirectExec.access$100().isDebugEnabled()) {
                        AsyncRedirectExec.access$100().debug("{} resetting target auth state", (Object)this.val$exchangeId);
                    }
                    ((AuthExchange)object2).reset();
                    if (((HttpRoute)object3).getProxyHost() != null && ((AuthExchange)(object2 = this.val$clientContext.getAuthExchange(((HttpRoute)object3).getProxyHost()))).isConnectionBased()) {
                        if (AsyncRedirectExec.access$100().isDebugEnabled()) {
                            AsyncRedirectExec.access$100().debug("{} resetting proxy auth state", (Object)this.val$exchangeId);
                        }
                        ((AuthExchange)object2).reset();
                    }
                }
            } else {
                object = object3;
            }
            this.val$state.currentScope = new AsyncExecChain$Scope(this.val$scope.exchangeId, (HttpRoute)object, BasicRequestBuilder.copy((HttpRequest)object4).build(), this.val$scope.cancellableDependency, this.val$scope.clientContext, this.val$scope.execRuntime, this.val$scope.scheduler, this.val$scope.execCount);
            if (AsyncRedirectExec.access$100().isDebugEnabled()) {
                AsyncRedirectExec.access$100().debug("{} redirecting to '{}' via {}", this.val$exchangeId, uRI, object);
            }
            return null;
        }
        return this.val$asyncExecCallback.handleResponse((HttpResponse)object, (EntityDetails)object2);
    }

    @Override
    public void handleInformationResponse(HttpResponse httpResponse) throws HttpException, IOException {
        this.val$asyncExecCallback.handleInformationResponse(httpResponse);
    }

    @Override
    public void completed() {
        if (this.val$state.redirectURI == null) {
            this.val$asyncExecCallback.completed();
            return;
        }
        AsyncEntityProducer asyncEntityProducer = this.val$state.currentEntityProducer;
        if (asyncEntityProducer != null) {
            asyncEntityProducer.releaseResources();
        }
        if (asyncEntityProducer != null && !asyncEntityProducer.isRepeatable()) {
            if (AsyncRedirectExec.access$100().isDebugEnabled()) {
                AsyncRedirectExec.access$100().debug("{} cannot redirect non-repeatable request", (Object)this.val$exchangeId);
            }
            this.val$asyncExecCallback.completed();
            return;
        }
        try {
            if (this.val$state.reroute) {
                this.val$scope.execRuntime.releaseEndpoint();
            }
            AsyncRedirectExec.access$300(this.this$0, this.val$state, this.val$chain, this.val$asyncExecCallback);
            return;
        }
        catch (IOException | HttpException exception) {
            this.val$asyncExecCallback.failed(exception);
            return;
        }
    }

    @Override
    public void failed(Exception exception) {
        this.val$asyncExecCallback.failed(exception);
    }
}

