/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.Closeable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.auth.AuthSchemeFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieSpecFactory;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.CookieSpecSupport;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.async.AsyncConnectExec;
import org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import org.apache.hc.client5.http.impl.async.AsyncHttpRequestRetryExec;
import org.apache.hc.client5.http.impl.async.AsyncProtocolExec;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.AsyncRedirectExec;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder$ExecInterceptorEntry;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder$ExecInterceptorEntry$Position;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder$IdleConnectionEvictor;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder$RequestInterceptorEntry;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder$RequestInterceptorEntry$Position;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder$ResponseInterceptorEntry;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder$ResponseInterceptorEntry$Position;
import org.apache.hc.client5.http.impl.async.H2AsyncClientProtocolStarter;
import org.apache.hc.client5.http.impl.async.H2AsyncMainClientExec;
import org.apache.hc.client5.http.impl.async.InternalH2AsyncClient;
import org.apache.hc.client5.http.impl.async.InternalH2ConnPool;
import org.apache.hc.client5.http.impl.async.LoggingExceptionCallback;
import org.apache.hc.client5.http.impl.async.LoggingIOSessionDecorator;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.BearerSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.impl.auth.SystemDefaultCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.MultihomeConnectionInitiator;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.protocol.RequestAddCookies;
import org.apache.hc.client5.http.protocol.RequestDefaultHeaders;
import org.apache.hc.client5.http.protocol.RequestExpectContinue;
import org.apache.hc.client5.http.protocol.ResponseProcessCookies;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.NamedElementChain;
import org.apache.hc.core5.http.config.NamedElementChain$Node;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.protocol.H2RequestConnControl;
import org.apache.hc.core5.http2.protocol.H2RequestContent;
import org.apache.hc.core5.http2.protocol.H2RequestTargetHost;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.VersionInfo;

public class H2AsyncClientBuilder {
    private IOReactorConfig ioReactorConfig;
    private IOSessionListener ioSessionListener;
    private H2Config h2Config;
    private CharCodingConfig charCodingConfig;
    private SchemePortResolver schemePortResolver;
    private AuthenticationStrategy targetAuthStrategy;
    private AuthenticationStrategy proxyAuthStrategy;
    private LinkedList<H2AsyncClientBuilder$RequestInterceptorEntry> requestInterceptors;
    private LinkedList<H2AsyncClientBuilder$ResponseInterceptorEntry> responseInterceptors;
    private LinkedList<H2AsyncClientBuilder$ExecInterceptorEntry> execInterceptors;
    private HttpRoutePlanner routePlanner;
    private RedirectStrategy redirectStrategy;
    private HttpRequestRetryStrategy retryStrategy;
    private Lookup<AuthSchemeFactory> authSchemeRegistry;
    private Lookup<CookieSpecFactory> cookieSpecRegistry;
    private CookieStore cookieStore;
    private CredentialsProvider credentialsProvider;
    private String userAgent;
    private Collection<? extends Header> defaultHeaders;
    private RequestConfig defaultRequestConfig;
    private Resolver<HttpHost, ConnectionConfig> connectionConfigResolver;
    private boolean evictIdleConnections;
    private TimeValue maxIdleTime;
    private boolean systemProperties;
    private boolean automaticRetriesDisabled;
    private boolean redirectHandlingDisabled;
    private boolean cookieManagementDisabled;
    private boolean authCachingDisabled;
    private DnsResolver dnsResolver;
    private TlsStrategy tlsStrategy;
    private ThreadFactory threadFactory;
    private List<Closeable> closeables;
    private Callback<Exception> ioReactorExceptionCallback;
    private Decorator<IOSession> ioSessionDecorator;

    public static H2AsyncClientBuilder create() {
        return new H2AsyncClientBuilder();
    }

    protected H2AsyncClientBuilder() {
    }

    public final H2AsyncClientBuilder setH2Config(H2Config h2Config) {
        this.h2Config = h2Config;
        return this;
    }

    public final H2AsyncClientBuilder setIOReactorConfig(IOReactorConfig iOReactorConfig) {
        this.ioReactorConfig = iOReactorConfig;
        return this;
    }

    public final H2AsyncClientBuilder setIOSessionListener(IOSessionListener iOSessionListener) {
        this.ioSessionListener = iOSessionListener;
        return this;
    }

    public final H2AsyncClientBuilder setCharCodingConfig(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final H2AsyncClientBuilder setTargetAuthenticationStrategy(AuthenticationStrategy authenticationStrategy) {
        this.targetAuthStrategy = authenticationStrategy;
        return this;
    }

    public final H2AsyncClientBuilder setProxyAuthenticationStrategy(AuthenticationStrategy authenticationStrategy) {
        this.proxyAuthStrategy = authenticationStrategy;
        return this;
    }

    public final H2AsyncClientBuilder setIoReactorExceptionCallback(Callback<Exception> callback) {
        this.ioReactorExceptionCallback = callback;
        return this;
    }

    public final H2AsyncClientBuilder setIoSessionDecorator(Decorator<IOSession> decorator) {
        this.ioSessionDecorator = decorator;
        return this;
    }

    public final H2AsyncClientBuilder addResponseInterceptorFirst(HttpResponseInterceptor httpResponseInterceptor) {
        Args.notNull(httpResponseInterceptor, "Interceptor");
        if (this.responseInterceptors == null) {
            this.responseInterceptors = new LinkedList();
        }
        this.responseInterceptors.add(new H2AsyncClientBuilder$ResponseInterceptorEntry(H2AsyncClientBuilder$ResponseInterceptorEntry$Position.FIRST, httpResponseInterceptor, null));
        return this;
    }

    public final H2AsyncClientBuilder addResponseInterceptorLast(HttpResponseInterceptor httpResponseInterceptor) {
        Args.notNull(httpResponseInterceptor, "Interceptor");
        if (this.responseInterceptors == null) {
            this.responseInterceptors = new LinkedList();
        }
        this.responseInterceptors.add(new H2AsyncClientBuilder$ResponseInterceptorEntry(H2AsyncClientBuilder$ResponseInterceptorEntry$Position.LAST, httpResponseInterceptor, null));
        return this;
    }

    public final H2AsyncClientBuilder addExecInterceptorBefore(String string, String string2, AsyncExecChainHandler asyncExecChainHandler) {
        Args.notBlank(string, "Existing");
        Args.notBlank(string2, "Name");
        Args.notNull(asyncExecChainHandler, "Interceptor");
        if (this.execInterceptors == null) {
            this.execInterceptors = new LinkedList();
        }
        this.execInterceptors.add(new H2AsyncClientBuilder$ExecInterceptorEntry(H2AsyncClientBuilder$ExecInterceptorEntry$Position.BEFORE, string2, asyncExecChainHandler, string, null));
        return this;
    }

    public final H2AsyncClientBuilder addExecInterceptorAfter(String string, String string2, AsyncExecChainHandler asyncExecChainHandler) {
        Args.notBlank(string, "Existing");
        Args.notBlank(string2, "Name");
        Args.notNull(asyncExecChainHandler, "Interceptor");
        if (this.execInterceptors == null) {
            this.execInterceptors = new LinkedList();
        }
        this.execInterceptors.add(new H2AsyncClientBuilder$ExecInterceptorEntry(H2AsyncClientBuilder$ExecInterceptorEntry$Position.AFTER, string2, asyncExecChainHandler, string, null));
        return this;
    }

    public final H2AsyncClientBuilder replaceExecInterceptor(String string, AsyncExecChainHandler asyncExecChainHandler) {
        Args.notBlank(string, "Existing");
        Args.notNull(asyncExecChainHandler, "Interceptor");
        if (this.execInterceptors == null) {
            this.execInterceptors = new LinkedList();
        }
        this.execInterceptors.add(new H2AsyncClientBuilder$ExecInterceptorEntry(H2AsyncClientBuilder$ExecInterceptorEntry$Position.REPLACE, string, asyncExecChainHandler, string, null));
        return this;
    }

    public final H2AsyncClientBuilder addExecInterceptorFirst(String string, AsyncExecChainHandler asyncExecChainHandler) {
        Args.notNull(string, "Name");
        Args.notNull(asyncExecChainHandler, "Interceptor");
        if (this.execInterceptors == null) {
            this.execInterceptors = new LinkedList();
        }
        this.execInterceptors.add(new H2AsyncClientBuilder$ExecInterceptorEntry(H2AsyncClientBuilder$ExecInterceptorEntry$Position.FIRST, string, asyncExecChainHandler, null, null));
        return this;
    }

    public final H2AsyncClientBuilder addExecInterceptorLast(String string, AsyncExecChainHandler asyncExecChainHandler) {
        Args.notNull(string, "Name");
        Args.notNull(asyncExecChainHandler, "Interceptor");
        if (this.execInterceptors == null) {
            this.execInterceptors = new LinkedList();
        }
        this.execInterceptors.add(new H2AsyncClientBuilder$ExecInterceptorEntry(H2AsyncClientBuilder$ExecInterceptorEntry$Position.LAST, string, asyncExecChainHandler, null, null));
        return this;
    }

    public final H2AsyncClientBuilder addRequestInterceptorFirst(HttpRequestInterceptor httpRequestInterceptor) {
        Args.notNull(httpRequestInterceptor, "Interceptor");
        if (this.requestInterceptors == null) {
            this.requestInterceptors = new LinkedList();
        }
        this.requestInterceptors.add(new H2AsyncClientBuilder$RequestInterceptorEntry(H2AsyncClientBuilder$RequestInterceptorEntry$Position.FIRST, httpRequestInterceptor, null));
        return this;
    }

    public final H2AsyncClientBuilder addRequestInterceptorLast(HttpRequestInterceptor httpRequestInterceptor) {
        Args.notNull(httpRequestInterceptor, "Interceptor");
        if (this.requestInterceptors == null) {
            this.requestInterceptors = new LinkedList();
        }
        this.requestInterceptors.add(new H2AsyncClientBuilder$RequestInterceptorEntry(H2AsyncClientBuilder$RequestInterceptorEntry$Position.LAST, httpRequestInterceptor, null));
        return this;
    }

    public final H2AsyncClientBuilder setRetryStrategy(HttpRequestRetryStrategy httpRequestRetryStrategy) {
        this.retryStrategy = httpRequestRetryStrategy;
        return this;
    }

    public H2AsyncClientBuilder setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
        return this;
    }

    public final H2AsyncClientBuilder setSchemePortResolver(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver;
        return this;
    }

    public final H2AsyncClientBuilder setDnsResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
        return this;
    }

    public final H2AsyncClientBuilder setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final H2AsyncClientBuilder setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public final H2AsyncClientBuilder setUserAgent(String string) {
        this.userAgent = string;
        return this;
    }

    public final H2AsyncClientBuilder setDefaultHeaders(Collection<? extends Header> collection) {
        this.defaultHeaders = collection;
        return this;
    }

    public final H2AsyncClientBuilder setRoutePlanner(HttpRoutePlanner httpRoutePlanner) {
        this.routePlanner = httpRoutePlanner;
        return this;
    }

    public final H2AsyncClientBuilder setDefaultCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public final H2AsyncClientBuilder setDefaultAuthSchemeRegistry(Lookup<AuthSchemeFactory> lookup) {
        this.authSchemeRegistry = lookup;
        return this;
    }

    public final H2AsyncClientBuilder setDefaultCookieSpecRegistry(Lookup<CookieSpecFactory> lookup) {
        this.cookieSpecRegistry = lookup;
        return this;
    }

    public final H2AsyncClientBuilder setDefaultCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public final H2AsyncClientBuilder setDefaultRequestConfig(RequestConfig requestConfig) {
        this.defaultRequestConfig = requestConfig;
        return this;
    }

    public final H2AsyncClientBuilder setConnectionConfigResolver(Resolver<HttpHost, ConnectionConfig> resolver) {
        this.connectionConfigResolver = resolver;
        return this;
    }

    public final H2AsyncClientBuilder setDefaultConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfigResolver = httpHost -> connectionConfig;
        return this;
    }

    public final H2AsyncClientBuilder useSystemProperties() {
        this.systemProperties = true;
        return this;
    }

    public final H2AsyncClientBuilder disableRedirectHandling() {
        this.redirectHandlingDisabled = true;
        return this;
    }

    public final H2AsyncClientBuilder disableAutomaticRetries() {
        this.automaticRetriesDisabled = true;
        return this;
    }

    public final H2AsyncClientBuilder disableCookieManagement() {
        this.cookieManagementDisabled = true;
        return this;
    }

    public final H2AsyncClientBuilder disableAuthCaching() {
        this.authCachingDisabled = true;
        return this;
    }

    public final H2AsyncClientBuilder evictIdleConnections(TimeValue timeValue) {
        this.evictIdleConnections = true;
        this.maxIdleTime = timeValue;
        return this;
    }

    @Internal
    protected void customizeExecChain(NamedElementChain<AsyncExecChainHandler> namedElementChain) {
    }

    @Internal
    protected void addCloseable(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        if (this.closeables == null) {
            this.closeables = new ArrayList<Closeable>();
        }
        this.closeables.add(closeable);
    }

    /*
     * WARNING - void declaration
     */
    public CloseableHttpAsyncClient build() {
        void var6_16;
        Object object;
        CredentialsProvider credentialsProvider;
        CookieStore cookieStore;
        Lookup<CookieSpecFactory> lookup;
        Object object2;
        Object object3;
        Object object4 = this.targetAuthStrategy;
        if (object4 == null) {
            object4 = DefaultAuthenticationStrategy.INSTANCE;
        }
        if ((object3 = this.proxyAuthStrategy) == null) {
            object3 = DefaultAuthenticationStrategy.INSTANCE;
        }
        if ((object2 = this.userAgent) == null) {
            if (this.systemProperties) {
                object2 = H2AsyncClientBuilder.getProperty("http.agent", null);
            }
            if (object2 == null) {
                object2 = VersionInfo.getSoftwareInfo("Apache-HttpAsyncClient", "org.apache.hc.client5", this.getClass());
            }
        }
        Lookup<AuthSchemeFactory> lookup2 = HttpProcessorBuilder.create();
        if (this.requestInterceptors != null) {
            for (H2AsyncClientBuilder$RequestInterceptorEntry lookup3 : this.requestInterceptors) {
                if (lookup3.position != H2AsyncClientBuilder$RequestInterceptorEntry$Position.FIRST) continue;
                ((HttpProcessorBuilder)((Object)lookup2)).addFirst(lookup3.interceptor);
            }
        }
        if (this.responseInterceptors != null) {
            for (H2AsyncClientBuilder$ResponseInterceptorEntry h2AsyncClientBuilder$ResponseInterceptorEntry : this.responseInterceptors) {
                if (h2AsyncClientBuilder$ResponseInterceptorEntry.position != H2AsyncClientBuilder$ResponseInterceptorEntry$Position.FIRST) continue;
                ((HttpProcessorBuilder)((Object)lookup2)).addFirst(h2AsyncClientBuilder$ResponseInterceptorEntry.interceptor);
            }
        }
        ((HttpProcessorBuilder)((Object)lookup2)).addAll(new H2RequestTargetHost(), new RequestDefaultHeaders(this.defaultHeaders), new RequestUserAgent((String)object2), new RequestExpectContinue(), new H2RequestContent(), new H2RequestConnControl());
        if (!this.cookieManagementDisabled) {
            ((HttpProcessorBuilder)((Object)lookup2)).add(RequestAddCookies.INSTANCE);
        }
        if (!this.cookieManagementDisabled) {
            ((HttpProcessorBuilder)((Object)lookup2)).add(ResponseProcessCookies.INSTANCE);
        }
        if (this.requestInterceptors != null) {
            for (H2AsyncClientBuilder$RequestInterceptorEntry h2AsyncClientBuilder$RequestInterceptorEntry : this.requestInterceptors) {
                if (h2AsyncClientBuilder$RequestInterceptorEntry.position != H2AsyncClientBuilder$RequestInterceptorEntry$Position.LAST) continue;
                ((HttpProcessorBuilder)((Object)lookup2)).addLast(h2AsyncClientBuilder$RequestInterceptorEntry.interceptor);
            }
        }
        if (this.responseInterceptors != null) {
            for (H2AsyncClientBuilder$ResponseInterceptorEntry h2AsyncClientBuilder$ResponseInterceptorEntry : this.responseInterceptors) {
                if (h2AsyncClientBuilder$ResponseInterceptorEntry.position != H2AsyncClientBuilder$ResponseInterceptorEntry$Position.LAST) continue;
                ((HttpProcessorBuilder)((Object)lookup2)).addLast(h2AsyncClientBuilder$ResponseInterceptorEntry.interceptor);
            }
        }
        Object object5 = ((HttpProcessorBuilder)((Object)lookup2)).build();
        NamedElementChain<AsyncExecChainHandler> namedElementChain = new NamedElementChain<AsyncExecChainHandler>();
        namedElementChain.addLast(new H2AsyncMainClientExec((HttpProcessor)object5), ChainElement.MAIN_TRANSPORT.name());
        namedElementChain.addFirst(new AsyncConnectExec(new DefaultHttpProcessor(new RequestTargetHost(), new RequestUserAgent((String)object2)), (AuthenticationStrategy)object3, this.schemePortResolver != null ? this.schemePortResolver : DefaultSchemePortResolver.INSTANCE, this.authCachingDisabled), ChainElement.CONNECT.name());
        namedElementChain.addFirst(new AsyncProtocolExec((AuthenticationStrategy)object4, (AuthenticationStrategy)object3, this.schemePortResolver != null ? this.schemePortResolver : DefaultSchemePortResolver.INSTANCE, this.authCachingDisabled), ChainElement.PROTOCOL.name());
        if (!this.automaticRetriesDisabled) {
            object4 = this.retryStrategy;
            if (object4 == null) {
                object4 = DefaultHttpRequestRetryStrategy.INSTANCE;
            }
            namedElementChain.addFirst(new AsyncHttpRequestRetryExec((HttpRequestRetryStrategy)object4), ChainElement.RETRY.name());
        }
        if ((object4 = this.routePlanner) == null) {
            object3 = this.schemePortResolver;
            if (object3 == null) {
                object3 = DefaultSchemePortResolver.INSTANCE;
            }
            object4 = new DefaultRoutePlanner((SchemePortResolver)object3);
        }
        if (!this.redirectHandlingDisabled) {
            object3 = this.redirectStrategy;
            if (object3 == null) {
                object3 = this.schemePortResolver != null ? new DefaultRedirectStrategy(this.schemePortResolver) : DefaultRedirectStrategy.INSTANCE;
            }
            namedElementChain.addFirst(new AsyncRedirectExec((HttpRoutePlanner)object4, (RedirectStrategy)object3), ChainElement.REDIRECT.name());
        }
        object3 = new AsyncPushConsumerRegistry();
        object2 = new H2AsyncClientProtocolStarter(HttpProcessorBuilder.create().build(), (arg_0, arg_1) -> H2AsyncClientBuilder.lambda$build$1((AsyncPushConsumerRegistry)object3, arg_0, arg_1), this.h2Config != null ? this.h2Config : H2Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.ioReactorExceptionCallback != null ? this.ioReactorExceptionCallback : LoggingExceptionCallback.INSTANCE);
        object2 = new DefaultConnectingIOReactor((IOEventHandlerFactory)object2, this.ioReactorConfig != null ? this.ioReactorConfig : IOReactorConfig.DEFAULT, this.threadFactory != null ? this.threadFactory : new DefaultThreadFactory("httpclient-dispatch", true), this.ioSessionDecorator != null ? this.ioSessionDecorator : LoggingIOSessionDecorator.INSTANCE, this.ioReactorExceptionCallback != null ? this.ioReactorExceptionCallback : LoggingExceptionCallback.INSTANCE, this.ioSessionListener, iOSession -> iOSession.enqueue(new ShutdownCommand(CloseMode.GRACEFUL), Command$Priority.IMMEDIATE));
        if (this.execInterceptors != null) {
            lookup2 = this.execInterceptors.iterator();
            while (lookup2.hasNext()) {
                object5 = (H2AsyncClientBuilder$ExecInterceptorEntry)lookup2.next();
                switch (((H2AsyncClientBuilder$ExecInterceptorEntry)object5).position) {
                    case AFTER: {
                        namedElementChain.addAfter(((H2AsyncClientBuilder$ExecInterceptorEntry)object5).existing, ((H2AsyncClientBuilder$ExecInterceptorEntry)object5).interceptor, ((H2AsyncClientBuilder$ExecInterceptorEntry)object5).name);
                        break;
                    }
                    case BEFORE: {
                        namedElementChain.addBefore(((H2AsyncClientBuilder$ExecInterceptorEntry)object5).existing, ((H2AsyncClientBuilder$ExecInterceptorEntry)object5).interceptor, ((H2AsyncClientBuilder$ExecInterceptorEntry)object5).name);
                        break;
                    }
                    case REPLACE: {
                        namedElementChain.replace(((H2AsyncClientBuilder$ExecInterceptorEntry)object5).existing, ((H2AsyncClientBuilder$ExecInterceptorEntry)object5).interceptor);
                        break;
                    }
                    case FIRST: {
                        namedElementChain.addFirst(((H2AsyncClientBuilder$ExecInterceptorEntry)object5).interceptor, ((H2AsyncClientBuilder$ExecInterceptorEntry)object5).name);
                        break;
                    }
                    case LAST: {
                        namedElementChain.addBefore(ChainElement.MAIN_TRANSPORT.name(), ((H2AsyncClientBuilder$ExecInterceptorEntry)object5).interceptor, ((H2AsyncClientBuilder$ExecInterceptorEntry)object5).name);
                    }
                }
            }
        }
        this.customizeExecChain(namedElementChain);
        object5 = null;
        for (lookup2 = namedElementChain.getLast(); lookup2 != null; lookup2 = ((NamedElementChain$Node)((Object)lookup2)).getPrevious()) {
            object5 = new AsyncExecChainElement((AsyncExecChainHandler)((NamedElementChain$Node)((Object)lookup2)).getValue(), (AsyncExecChainElement)object5);
        }
        lookup2 = this.authSchemeRegistry;
        if (lookup2 == null) {
            lookup2 = RegistryBuilder.create().register("Basic", BasicSchemeFactory.INSTANCE).register("Digest", (BasicSchemeFactory)((Object)DigestSchemeFactory.INSTANCE)).register("Bearer", (BasicSchemeFactory)((Object)BearerSchemeFactory.INSTANCE)).build();
        }
        if ((lookup = this.cookieSpecRegistry) == null) {
            Lookup<CookieSpecFactory> lookup3 = CookieSpecSupport.createDefault();
        }
        if ((cookieStore = this.cookieStore) == null) {
            cookieStore = new BasicCookieStore();
        }
        if ((credentialsProvider = this.credentialsProvider) == null) {
            credentialsProvider = this.systemProperties ? new SystemDefaultCredentialsProvider() : new BasicCredentialsProvider();
        }
        if ((object = this.tlsStrategy) == null) {
            object = this.systemProperties ? DefaultClientTlsStrategy.createSystemDefault() : DefaultClientTlsStrategy.createDefault();
        }
        ArrayList<Closeable> arrayList = new MultihomeConnectionInitiator((ConnectionInitiator)object2, this.dnsResolver);
        object = new InternalH2ConnPool((ConnectionInitiator)((Object)arrayList), httpHost -> null, (TlsStrategy)object);
        ((InternalH2ConnPool)object).setConnectionConfigResolver(this.connectionConfigResolver);
        arrayList = this.closeables != null ? new ArrayList<Closeable>(this.closeables) : null;
        if (arrayList == null) {
            arrayList = new ArrayList<Closeable>(1);
        }
        if (this.evictIdleConnections) {
            H2AsyncClientBuilder$IdleConnectionEvictor h2AsyncClientBuilder$IdleConnectionEvictor = new H2AsyncClientBuilder$IdleConnectionEvictor((InternalH2ConnPool)object, this.maxIdleTime != null ? this.maxIdleTime : TimeValue.ofSeconds(30L));
            arrayList.add(h2AsyncClientBuilder$IdleConnectionEvictor::shutdown);
            h2AsyncClientBuilder$IdleConnectionEvictor.start();
        }
        arrayList.add((Closeable)object);
        return new InternalH2AsyncClient((DefaultConnectingIOReactor)object2, (AsyncExecChainElement)object5, (AsyncPushConsumerRegistry)object3, this.threadFactory != null ? this.threadFactory : new DefaultThreadFactory("httpclient-main", true), (InternalH2ConnPool)object, (HttpRoutePlanner)object4, (Lookup<CookieSpecFactory>)var6_16, lookup2, cookieStore, credentialsProvider, this.defaultRequestConfig, arrayList);
    }

    private static String getProperty(String string, String string2) {
        return AccessController.doPrivileged(() -> System.getProperty(string, string2));
    }

    private static /* synthetic */ AsyncPushConsumer lambda$build$1(AsyncPushConsumerRegistry asyncPushConsumerRegistry, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        return asyncPushConsumerRegistry.get(httpRequest);
    }
}

