/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.H2AsyncClientProtocolStarter;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientProtocolNegotiationStarter;
import org.apache.hc.client5.http.impl.async.LoggingExceptionCallback;
import org.apache.hc.client5.http.impl.async.MinimalH2AsyncClient;
import org.apache.hc.client5.http.impl.async.MinimalHttpAsyncClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncAdaptor;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.protocol.H2RequestConnControl;
import org.apache.hc.core5.http2.protocol.H2RequestContent;
import org.apache.hc.core5.http2.protocol.H2RequestTargetHost;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;
import org.apache.hc.core5.util.VersionInfo;

public final class HttpAsyncClients {
    private HttpAsyncClients() {
    }

    public static HttpAsyncClientBuilder custom() {
        return HttpAsyncClientBuilder.create();
    }

    public static CloseableHttpAsyncClient createDefault() {
        return HttpAsyncClientBuilder.create().build();
    }

    public static CloseableHttpAsyncClient createSystem() {
        return HttpAsyncClientBuilder.create().useSystemProperties().build();
    }

    public static H2AsyncClientBuilder customHttp2() {
        return H2AsyncClientBuilder.create();
    }

    public static CloseableHttpAsyncClient createHttp2Default() {
        return H2AsyncClientBuilder.create().build();
    }

    public static CloseableHttpAsyncClient createHttp2System() {
        return H2AsyncClientBuilder.create().useSystemProperties().build();
    }

    private static HttpProcessor createMinimalProtocolProcessor() {
        return new DefaultHttpProcessor(new H2RequestTargetHost(), new H2RequestContent(), new H2RequestConnControl(), new RequestUserAgent(VersionInfo.getSoftwareInfo("Apache-HttpAsyncClient", "org.apache.hc.client5", HttpAsyncClients.class)));
    }

    private static MinimalHttpAsyncClient createMinimalHttpAsyncClientImpl(IOEventHandlerFactory iOEventHandlerFactory, AsyncPushConsumerRegistry asyncPushConsumerRegistry, IOReactorConfig iOReactorConfig, AsyncClientConnectionManager asyncClientConnectionManager, SchemePortResolver schemePortResolver, TlsConfig tlsConfig) {
        return new MinimalHttpAsyncClient(iOEventHandlerFactory, asyncPushConsumerRegistry, iOReactorConfig, new DefaultThreadFactory("httpclient-main", true), new DefaultThreadFactory("httpclient-dispatch", true), asyncClientConnectionManager, schemePortResolver, tlsConfig);
    }

    @Deprecated
    public static MinimalHttpAsyncClient createMinimal(HttpVersionPolicy httpVersionPolicy, H2Config h2Config, Http1Config http1Config, IOReactorConfig iOReactorConfig, AsyncClientConnectionManager asyncClientConnectionManager) {
        AsyncPushConsumerRegistry asyncPushConsumerRegistry = new AsyncPushConsumerRegistry();
        return HttpAsyncClients.createMinimalHttpAsyncClientImpl(new HttpAsyncClientProtocolNegotiationStarter(HttpAsyncClients.createMinimalProtocolProcessor(), (httpRequest, httpContext) -> asyncPushConsumerRegistry.get(httpRequest), h2Config, http1Config, CharCodingConfig.DEFAULT, DefaultClientConnectionReuseStrategy.INSTANCE, LoggingExceptionCallback.INSTANCE), asyncPushConsumerRegistry, iOReactorConfig, asyncClientConnectionManager, DefaultSchemePortResolver.INSTANCE, httpVersionPolicy != null ? TlsConfig.custom().setVersionPolicy(httpVersionPolicy).build() : null);
    }

    public static MinimalHttpAsyncClient createMinimal(H2Config h2Config, Http1Config http1Config, IOReactorConfig iOReactorConfig, AsyncClientConnectionManager asyncClientConnectionManager) {
        AsyncPushConsumerRegistry asyncPushConsumerRegistry = new AsyncPushConsumerRegistry();
        return HttpAsyncClients.createMinimalHttpAsyncClientImpl(new HttpAsyncClientProtocolNegotiationStarter(HttpAsyncClients.createMinimalProtocolProcessor(), (httpRequest, httpContext) -> asyncPushConsumerRegistry.get(httpRequest), h2Config, http1Config, CharCodingConfig.DEFAULT, DefaultClientConnectionReuseStrategy.INSTANCE, LoggingExceptionCallback.INSTANCE), asyncPushConsumerRegistry, iOReactorConfig, asyncClientConnectionManager, DefaultSchemePortResolver.INSTANCE, null);
    }

    @Deprecated
    public static MinimalHttpAsyncClient createMinimal(HttpVersionPolicy httpVersionPolicy, H2Config h2Config, Http1Config http1Config, IOReactorConfig iOReactorConfig) {
        return HttpAsyncClients.createMinimal(httpVersionPolicy, h2Config, http1Config, iOReactorConfig, PoolingAsyncClientConnectionManagerBuilder.create().build());
    }

    public static MinimalHttpAsyncClient createMinimal(H2Config h2Config, Http1Config http1Config, IOReactorConfig iOReactorConfig) {
        return HttpAsyncClients.createMinimal(h2Config, http1Config, iOReactorConfig, PoolingAsyncClientConnectionManagerBuilder.create().build());
    }

    public static MinimalHttpAsyncClient createMinimal(H2Config h2Config, Http1Config http1Config) {
        return HttpAsyncClients.createMinimal(HttpVersionPolicy.NEGOTIATE, h2Config, http1Config, IOReactorConfig.DEFAULT);
    }

    public static MinimalHttpAsyncClient createMinimal() {
        return HttpAsyncClients.createMinimal(H2Config.DEFAULT, Http1Config.DEFAULT);
    }

    public static MinimalHttpAsyncClient createMinimal(AsyncClientConnectionManager asyncClientConnectionManager) {
        return HttpAsyncClients.createMinimal(HttpVersionPolicy.NEGOTIATE, H2Config.DEFAULT, Http1Config.DEFAULT, IOReactorConfig.DEFAULT, asyncClientConnectionManager);
    }

    private static MinimalH2AsyncClient createMinimalHttp2AsyncClientImpl(IOEventHandlerFactory iOEventHandlerFactory, AsyncPushConsumerRegistry asyncPushConsumerRegistry, IOReactorConfig iOReactorConfig, DnsResolver dnsResolver, TlsStrategy tlsStrategy) {
        return new MinimalH2AsyncClient(iOEventHandlerFactory, asyncPushConsumerRegistry, iOReactorConfig, new DefaultThreadFactory("httpclient-main", true), new DefaultThreadFactory("httpclient-dispatch", true), dnsResolver, tlsStrategy);
    }

    public static MinimalH2AsyncClient createHttp2Minimal(H2Config h2Config, IOReactorConfig iOReactorConfig, DnsResolver dnsResolver, TlsStrategy tlsStrategy) {
        AsyncPushConsumerRegistry asyncPushConsumerRegistry = new AsyncPushConsumerRegistry();
        return HttpAsyncClients.createMinimalHttp2AsyncClientImpl(new H2AsyncClientProtocolStarter(HttpAsyncClients.createMinimalProtocolProcessor(), (httpRequest, httpContext) -> asyncPushConsumerRegistry.get(httpRequest), h2Config, CharCodingConfig.DEFAULT, LoggingExceptionCallback.INSTANCE), asyncPushConsumerRegistry, iOReactorConfig, dnsResolver, tlsStrategy);
    }

    public static MinimalH2AsyncClient createHttp2Minimal(H2Config h2Config, IOReactorConfig iOReactorConfig, TlsStrategy tlsStrategy) {
        return HttpAsyncClients.createHttp2Minimal(h2Config, iOReactorConfig, SystemDefaultDnsResolver.INSTANCE, tlsStrategy);
    }

    public static MinimalH2AsyncClient createHttp2Minimal(H2Config h2Config, IOReactorConfig iOReactorConfig) {
        return HttpAsyncClients.createHttp2Minimal(h2Config, iOReactorConfig, DefaultClientTlsStrategy.createDefault());
    }

    public static MinimalH2AsyncClient createHttp2Minimal(H2Config h2Config) {
        return HttpAsyncClients.createHttp2Minimal(h2Config, IOReactorConfig.DEFAULT);
    }

    public static MinimalH2AsyncClient createHttp2Minimal() {
        return HttpAsyncClients.createHttp2Minimal(H2Config.DEFAULT);
    }

    public static HandlerFactory<AsyncPushConsumer> pushRouter(RequestRouter<Supplier<AsyncPushConsumer>> requestRouter) {
        return (httpRequest, httpContext) -> {
            if ((requestRouter = (Supplier)((RequestRouter)requestRouter).resolve(httpRequest, httpContext)) != null) {
                return (AsyncPushConsumer)requestRouter.get();
            }
            return null;
        };
    }

    @Experimental
    public static CloseableHttpClient classic(CloseableHttpAsyncClient closeableHttpAsyncClient, Timeout timeout) {
        closeableHttpAsyncClient.start();
        return new ClassicToAsyncAdaptor(closeableHttpAsyncClient, timeout);
    }
}

