/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.impl.async.HttpAsyncMainClientExec;
import org.apache.hc.client5.http.impl.async.HttpAsyncMainClientExec$1$1;
import org.apache.hc.client5.http.impl.async.HttpAsyncMainClientExec$1$2;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;

class HttpAsyncMainClientExec$1
implements AsyncClientExchangeHandler {
    private final AtomicReference<AsyncDataConsumer> entityConsumerRef = new AtomicReference();
    final /* synthetic */ AsyncExecRuntime val$execRuntime;
    final /* synthetic */ AsyncExecCallback val$asyncExecCallback;
    final /* synthetic */ AtomicInteger val$messageCountDown;
    final /* synthetic */ HttpClientContext val$clientContext;
    final /* synthetic */ HttpRoute val$route;
    final /* synthetic */ HttpRequest val$request;
    final /* synthetic */ AsyncEntityProducer val$entityProducer;
    final /* synthetic */ HttpAsyncMainClientExec this$0;

    HttpAsyncMainClientExec$1(HttpAsyncMainClientExec httpAsyncMainClientExec, AsyncExecRuntime asyncExecRuntime, AsyncExecCallback asyncExecCallback, AtomicInteger atomicInteger, HttpClientContext httpClientContext, HttpRoute httpRoute, HttpRequest httpRequest, AsyncEntityProducer asyncEntityProducer) {
        this.this$0 = httpAsyncMainClientExec;
        this.val$execRuntime = asyncExecRuntime;
        this.val$asyncExecCallback = asyncExecCallback;
        this.val$messageCountDown = atomicInteger;
        this.val$clientContext = httpClientContext;
        this.val$route = httpRoute;
        this.val$request = httpRequest;
        this.val$entityProducer = asyncEntityProducer;
    }

    @Override
    public void releaseResources() {
        AsyncDataConsumer asyncDataConsumer = this.entityConsumerRef.getAndSet(null);
        if (asyncDataConsumer != null) {
            asyncDataConsumer.releaseResources();
        }
    }

    @Override
    public void failed(Exception exception) {
        AsyncDataConsumer asyncDataConsumer = this.entityConsumerRef.getAndSet(null);
        if (asyncDataConsumer != null) {
            asyncDataConsumer.releaseResources();
        }
        this.val$execRuntime.markConnectionNonReusable();
        this.val$asyncExecCallback.failed(exception);
    }

    @Override
    public void cancel() {
        if (this.val$messageCountDown.get() > 0) {
            this.failed(new InterruptedIOException());
        }
    }

    @Override
    public void produceRequest(RequestChannel requestChannel, HttpContext httpContext) throws HttpException, IOException {
        this.val$clientContext.setRoute(this.val$route);
        this.val$clientContext.setRequest(this.val$request);
        HttpAsyncMainClientExec.access$000(this.this$0).process(this.val$request, (EntityDetails)this.val$entityProducer, (HttpContext)this.val$clientContext);
        requestChannel.sendRequest(this.val$request, this.val$entityProducer, httpContext);
        if (this.val$entityProducer == null) {
            this.val$messageCountDown.decrementAndGet();
        }
    }

    @Override
    public int available() {
        return this.val$entityProducer.available();
    }

    @Override
    public void produce(DataStreamChannel dataStreamChannel) throws IOException {
        this.val$entityProducer.produce(new HttpAsyncMainClientExec$1$1(this, dataStreamChannel));
    }

    @Override
    public void consumeInformation(HttpResponse object, HttpContext httpContext) throws HttpException, IOException {
        if (object.getCode() == 101) {
            object = HttpAsyncMainClientExec.access$100(this.this$0).switchProtocol((HttpMessage)object);
            if (object == null || !((ProtocolVersion)object).getProtocol().equals("TLS")) {
                throw new ProtocolException("Failure switching protocols");
            }
            if (HttpAsyncMainClientExec.access$200().isDebugEnabled()) {
                HttpAsyncMainClientExec.access$200().debug("Switching to {}", object);
            }
            this.val$execRuntime.upgradeTls(this.val$clientContext, new HttpAsyncMainClientExec$1$2(this, (ProtocolVersion)object));
            return;
        }
        this.val$asyncExecCallback.handleInformationResponse((HttpResponse)object);
    }

    @Override
    public void consumeResponse(HttpResponse object, EntityDetails entityDetails, HttpContext object2) throws HttpException, IOException {
        this.val$clientContext.setResponse((HttpResponse)object);
        HttpAsyncMainClientExec.access$000(this.this$0).process((HttpResponse)object, entityDetails, (HttpContext)this.val$clientContext);
        this.entityConsumerRef.set(this.val$asyncExecCallback.handleResponse((HttpResponse)object, entityDetails));
        if (object.getCode() >= 400) {
            this.val$messageCountDown.decrementAndGet();
        }
        object = HttpAsyncMainClientExec.access$300(this.this$0).getKeepAliveDuration((HttpResponse)object, this.val$clientContext);
        object2 = this.val$clientContext.getUserToken();
        if (object2 == null) {
            object2 = HttpAsyncMainClientExec.access$400(this.this$0).getUserToken(this.val$route, this.val$request, this.val$clientContext);
            this.val$clientContext.setUserToken(object2);
        }
        this.val$execRuntime.markConnectionReusable(object2, (TimeValue)object);
        if (entityDetails == null) {
            this.val$execRuntime.validateConnection();
            if (this.val$messageCountDown.decrementAndGet() <= 0) {
                this.val$asyncExecCallback.completed();
            }
        }
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncDataConsumer asyncDataConsumer = this.entityConsumerRef.get();
        if (asyncDataConsumer != null) {
            asyncDataConsumer.updateCapacity(capacityChannel);
            return;
        }
        capacityChannel.update(Integer.MAX_VALUE);
    }

    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        AsyncDataConsumer asyncDataConsumer = this.entityConsumerRef.get();
        if (asyncDataConsumer != null) {
            asyncDataConsumer.consume(byteBuffer);
        }
    }

    @Override
    public void streamEnd(List<? extends Header> list) throws HttpException, IOException {
        AsyncDataConsumer asyncDataConsumer = this.entityConsumerRef.getAndSet(null);
        if (asyncDataConsumer != null) {
            asyncDataConsumer.streamEnd(list);
        } else {
            this.val$execRuntime.validateConnection();
        }
        if (this.val$messageCountDown.decrementAndGet() <= 0) {
            this.val$asyncExecCallback.completed();
        }
    }
}

